/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils.excel.imports;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelUtil {
    private ExcelUtil() {
    }

    public static final ExcelUtil getInstance() {
        return LazyHolder.INSTANCE;
    }

    public List<List<List<String>>> getContent(String filePath, List<Integer> cellNum) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<List<String>>> content = new ArrayList<List<List<String>>>();
        int i = 0;
        while (i < hwb.getNumberOfSheets()) {
            sheet = hwb.getSheetAt(i);
            ArrayList sheetContent = new ArrayList();
            int j = 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                int k = 0;
                while (k < cellNum.get(i)) {
                    rowContent.add(this.getCellValue(row.getCell(k)));
                    ++k;
                }
                sheetContent.add(rowContent);
                ++j;
            }
            content.add(sheetContent);
            ++i;
        }
        return content;
    }

    private String getCellValue(HSSFCell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                long dd = (long)cell.getNumericCellValue();
                value = String.valueOf(dd);
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 2: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    /* synthetic */ ExcelUtil(ExcelUtil excelUtil) {
        this();
    }

    private static class LazyHolder {
        private static final ExcelUtil INSTANCE = new ExcelUtil(null);

        private LazyHolder() {
        }
    }
}

