/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils.excel;

import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.OccupationalRiskFactors;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.Workroleinfo;
import cn.smarthse.core.model.hccheckplan.HcCheckPlan;
import cn.smarthse.core.model.shield.EquipWorkRoleGroup;
import cn.smarthse.core.model.shield.EquipworkroleVO;
import cn.smarthse.core.model.shield.Equipworkroleheader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportExcel<T> {
    public void export(String title, String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth((short)15);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor((short)40);
        style.setFillPattern((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        HSSFFont font = workbook.createFont();
        font.setColor((short)20);
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        style.setFont(font);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor((short)43);
        style2.setFillPattern((short)1);
        style2.setBorderBottom((short)1);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setAlignment((short)2);
        style2.setVerticalAlignment((short)1);
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)400);
        style2.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
        comment.setAuthor("admin");
        HSSFRow row = sheet.createRow(0);
        short i = 0;
        while (i < headers.length) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(style);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            i = (short)(i + 1);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            short i2 = 0;
            while (i2 < fields.length) {
                HSSFCell cell = row.createCell(i2);
                cell.setCellStyle(style2);
                Field field = fields[i2];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    }
                    if (value instanceof Boolean) {
                        boolean bValue = (Boolean)value;
                        textValue = "\u7537";
                        if (!bValue) {
                            textValue = "\u5973";
                        }
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i2, (short)2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(2);
                        patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue != null) {
                        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                        Matcher matcher = p.matcher(textValue);
                        if (matcher.matches()) {
                            cell.setCellValue(Double.parseDouble(textValue));
                        } else {
                            HSSFRichTextString richString = new HSSFRichTextString(textValue);
                            HSSFFont font3 = workbook.createFont();
                            font3.setColor((short)12);
                            richString.applyFont((Font)font3);
                            cell.setCellValue((RichTextString)richString);
                        }
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                i2 = (short)(i2 + 1);
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void simpleExport(String title, String[] headers, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < headers.length) {
            row.createCell(i).setCellValue(headers[i]);
            ++i;
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            int i2 = 0;
            while (i2 < fields.length) {
                HSSFCell cell = row.createCell(i2);
                Field field = fields[i2];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value != null) {
                        if (value instanceof Integer) {
                            int intValue = (Integer)value;
                            cell.setCellValue((double)intValue);
                        } else if (value instanceof Float) {
                            float fValue = ((Float)value).floatValue();
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Double) {
                            double dValue = (Double)value;
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Long) {
                            long longValue = (Long)value;
                            cell.setCellValue((double)longValue);
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            textValue = sdf.format(date);
                        } else {
                            textValue = value.toString();
                        }
                        if (textValue != null) {
                            Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                            Matcher matcher = p.matcher(textValue);
                            if (matcher.matches()) {
                                cell.setCellValue(Double.parseDouble(textValue));
                            } else {
                                cell.setCellValue(textValue);
                            }
                        }
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        try {
            try {
                workbook.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    workbook.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void simpleExport2(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        String[] stringArray = colums;
        int n = colums.length;
        int n2 = 0;
        while (n2 < n) {
            String colum = stringArray[n2];
            String[] t = colum.split("\\|");
            if (t.length == 2) {
                headers.add(t[0]);
                fieldNames.add(t[1]);
            }
            ++n2;
        }
        int i = 0;
        while (i < headers.size()) {
            row.createCell(i).setCellValue((String)headers.get(i));
            ++i;
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            int i2 = 0;
            while (i2 < fieldNames.size()) {
                HSSFCell cell = row.createCell(i2);
                String fieldName = (String)fieldNames.get(i2);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value != null) {
                        if (value instanceof Integer) {
                            int intValue = (Integer)value;
                            cell.setCellValue((double)intValue);
                        } else if (value instanceof Float) {
                            float fValue = ((Float)value).floatValue();
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Double) {
                            double dValue = (Double)value;
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Long) {
                            long longValue = (Long)value;
                            cell.setCellValue((double)longValue);
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            textValue = sdf.format(date);
                        } else {
                            textValue = value.toString();
                        }
                        if (textValue != null) {
                            Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                            Matcher matcher = p.matcher(textValue);
                            if (matcher.matches()) {
                                cell.setCellValue(Double.parseDouble(textValue));
                            } else {
                                cell.setCellValue(textValue);
                            }
                        }
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        try {
            try {
                workbook.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    workbook.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void simpleExport3(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        String[] stringArray = colums;
        int n = colums.length;
        int n2 = 0;
        while (n2 < n) {
            String colum = stringArray[n2];
            String[] t = colum.split("\\|");
            if (t.length == 2) {
                headers.add(t[0]);
                fieldNames.add(t[1]);
            }
            ++n2;
        }
        int i = 0;
        while (i < headers.size()) {
            row.createCell(i).setCellValue((String)headers.get(i));
            ++i;
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            int i2 = 0;
            while (i2 < fieldNames.size()) {
                HSSFCell cell = row.createCell(i2);
                String fieldName = (String)fieldNames.get(i2);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value != null) {
                        if (value instanceof Integer) {
                            int intValue = (Integer)value;
                            cell.setCellValue((double)intValue);
                        } else if (value instanceof Float) {
                            float fValue = ((Float)value).floatValue();
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Double) {
                            double dValue = (Double)value;
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Long) {
                            long longValue = (Long)value;
                            cell.setCellValue((double)longValue);
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            textValue = sdf.format(date);
                        } else {
                            textValue = value instanceof Area ? ((Area)value).getAreaname() : (value instanceof HcCheckPlan ? ((HcCheckPlan)value).getCheckreportName() : (value instanceof OccupationalRiskFactors ? ((OccupationalRiskFactors)value).getNameCh() : (value instanceof Workroleinfo ? ((Workroleinfo)value).getWorkname() : (value instanceof Staff ? ((Staff)value).getBasic().getRealname() : value.toString()))));
                        }
                        if (textValue != null) {
                            Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                            Matcher matcher = p.matcher(textValue);
                            if (matcher.matches()) {
                                cell.setCellValue(Double.parseDouble(textValue));
                            } else {
                                cell.setCellValue(textValue);
                            }
                        }
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        try {
            try {
                workbook.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    workbook.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void exportExcel(String fileName, String sheetName, String[] headers, List<T> datas, OutputStream out, int mergeIndex) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment((short)1);
            style.setAlignment((short)2);
            ArrayList<String> titles = new ArrayList<String>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String colum = stringArray[n2];
                String[] t = colum.split("\\|");
                if (t.length == 2) {
                    titles.add(t[0]);
                    fieldNames.add(t[1]);
                }
                ++n2;
            }
            HSSFRow row = sheet.createRow(0);
            int i = 0;
            while (i < titles.size()) {
                row.createCell(i).setCellValue((String)titles.get(i));
                ++i;
            }
            String mergeValue = null;
            boolean mergeFlag = false;
            int mergeCount = 0;
            Iterator<T> it = datas.iterator();
            int index = 0;
            while (it.hasNext()) {
                row = sheet.createRow(++index);
                T t = it.next();
                int i2 = 0;
                while (i2 < fieldNames.size()) {
                    String fieldName = (String)fieldNames.get(i2);
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        Object value = getMethod.invoke(t, new Object[0]);
                        if (value != null) {
                            String textValue = value.toString();
                            HSSFCell cell = null;
                            if (mergeIndex != i2) {
                                cell = row.createCell(i2);
                                cell.setCellValue(textValue);
                            } else if (mergeValue == null || !textValue.equals(mergeValue)) {
                                mergeValue = textValue;
                                cell = row.createCell(i2);
                                cell.setCellValue(textValue);
                                mergeFlag = mergeCount > 0;
                            } else {
                                ++mergeCount;
                                mergeFlag = false;
                            }
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    ++i2;
                }
                if (mergeCount <= 0 || !mergeFlag) continue;
                sheet.addMergedRegion(new CellRangeAddress(index - mergeCount, index, 0, 0));
                mergeCount = 0;
                mergeFlag = false;
            }
            try {
                try {
                    wb.write(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        wb.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exportMergeExcel(String fileName, String sheetName, String[] headers, Map<String, EquipWorkRoleGroup> groups, OutputStream out) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment((short)1);
            style.setAlignment((short)2);
            ArrayList<String> titles = new ArrayList<String>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String colum = stringArray[n2];
                String[] t = colum.split("\\|");
                if (t.length == 2) {
                    titles.add(t[0]);
                    fieldNames.add(t[1]);
                }
                ++n2;
            }
            HSSFRow row = sheet.createRow(0);
            int i = 0;
            while (i < titles.size()) {
                row.createCell(i).setCellValue((String)titles.get(i));
                ++i;
            }
            i = 0;
            for (Map.Entry entry : groups.entrySet()) {
                EquipWorkRoleGroup group = (EquipWorkRoleGroup)entry.getValue();
                List<EquipworkroleVO> list = group.getList();
                int j = 0;
                while (j < list.size()) {
                    EquipworkroleVO vo = list.get(j);
                    row = sheet.createRow(++i);
                    if (j == 0) {
                        HSSFCell cell0 = row.createCell(0);
                        cell0.setCellValue(group.getWorkName());
                    }
                    HSSFCell cell1 = row.createCell(1);
                    cell1.setCellValue(vo.getShieldTypeName());
                    HSSFCell cell2 = row.createCell(2);
                    cell2.setCellValue(vo.getShieldName());
                    HSSFCell cell3 = row.createCell(3);
                    cell3.setCellValue(vo.getCustomCycle());
                    ++j;
                }
                if (list.size() <= 1) continue;
                System.out.println(String.valueOf(i - list.size() + 1) + "   " + i);
                sheet.addMergedRegion(new CellRangeAddress(i - list.size() + 1, i, 0, 0));
            }
            try {
                try {
                    wb.write(out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        wb.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exportMergeExcel2(String fileName, String sheetName, String[] titles, List<Equipworkroleheader> list, OutputStream out) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment((short)1);
            style.setAlignment((short)2);
            HSSFRow row = sheet.createRow(0);
            int i = 0;
            while (i < titles.length) {
                row.createCell(i).setCellValue(titles[i]);
                ++i;
            }
            i = 0;
            for (Equipworkroleheader entry : list) {
                HSSFCell cell3;
                HSSFCell cell2;
                HSSFCell cell1;
                List<EquipworkroleVO> shields = entry.getList();
                if (shields != null && shields.size() > 0) {
                    int j = 0;
                    while (j < shields.size()) {
                        EquipworkroleVO vo = shields.get(j);
                        row = sheet.createRow(++i);
                        if (j == 0) {
                            HSSFCell cell0 = row.createCell(0);
                            cell0.setCellValue(entry.getWork().getWorkname());
                        }
                        cell1 = row.createCell(1);
                        cell1.setCellValue(vo.getShieldTypeName());
                        cell2 = row.createCell(2);
                        cell2.setCellValue(vo.getShieldName());
                        cell3 = row.createCell(3);
                        cell3.setCellValue(vo.getCustomCycle());
                        ++j;
                    }
                    sheet.addMergedRegion(new CellRangeAddress(i - shields.size() + 1, i, 0, 0));
                    continue;
                }
                EquipworkroleVO vo = new EquipworkroleVO();
                row = sheet.createRow(++i);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(entry.getWork().getWorkname());
                cell1 = row.createCell(1);
                cell1.setCellValue(vo.getShieldTypeName());
                cell2 = row.createCell(2);
                cell2.setCellValue(vo.getShieldName());
                cell3 = row.createCell(3);
                cell3.setCellValue(vo.getCustomCycle());
            }
            try {
                try {
                    wb.write(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        wb.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

