/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringEscapeUtils;

public class EncodeUtils {
    private static final String DEFAULT_URL_ENCODING = "UTF-8";

    public static String hexEncode(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    public static byte[] hexDecode(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException("Hex Decoder exception", e);
        }
    }

    public static String base64Encode(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String base64UrlSafeEncode(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    public static byte[] base64Decode(String input) {
        return Base64.decodeBase64((String)input);
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding Exception", e);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding Exception", e);
        }
    }

    public static String htmlEscape(String html) {
        return StringEscapeUtils.escapeHtml((String)html);
    }

    public static String htmlUnescape(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml((String)htmlEscaped);
    }

    public static String xmlEscape(String xml) {
        return StringEscapeUtils.escapeXml((String)xml);
    }

    public static String xmlUnescape(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }
}

