/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils;

import cn.smarthse.core.framework.common.util.date.DateStyle;
import cn.smarthse.core.framework.common.util.date.SimpleLunarCalendar;
import cn.smarthse.core.framework.common.util.date.Week;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.joda.time.DateTime;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    private static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT_YMD = "yyyy-MM-dd";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();

    public static String getCurrentTime() {
        return new DateTime().toString(DATE_FORMAT_DEFAULT);
    }

    public static String getCurrentDay() {
        return new DateTime().toString(DATE_FORMAT_YMD);
    }

    public static String getDate() {
        return DateUtils.getDate(DATE_FORMAT_YMD);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, DATE_FORMAT_YMD);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, DATE_FORMAT_DEFAULT);
    }

    public static String getTime() {
        return DateUtils.format(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.format(new Date(), DATE_FORMAT_DEFAULT);
    }

    public static String getYear() {
        return DateUtils.format(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.format(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.format(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.format(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null || StringUtils.isEmpty((String)str.toString())) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return String.valueOf(day > 0L ? String.valueOf(day) + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static long getDistanceOfTodayDate(Date after) {
        long beforeTime = System.currentTimeMillis();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        if (dateFormat == null) {
            Object object = DateUtils.object;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(pattern);
                    dateFormat.setLenient(false);
                    threadLocal.set(dateFormat);
                }
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    private static int getInteger(Date date, int dateType) {
        int num = 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
            num = calendar.get(dateType);
        }
        return num;
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtils.StringToDate(date, dateStyle);
            myDate = DateUtils.addInteger(myDate, dateType, amount);
            dateString = DateUtils.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                int i = 0;
                while (i < timestamps.size()) {
                    int j = i + 1;
                    while (j < timestamps.size()) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                        ++j;
                    }
                    ++i;
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                    int i2 = 1;
                    while (i2 < absoluteValues.size()) {
                        if (minAbsoluteValue > (Long)absoluteValues.get(i2)) {
                            minAbsoluteValue = (Long)absoluteValues.get(i2);
                        }
                        ++i2;
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    long dateOne = timestampsLastTmp[0];
                    long dateTwo = timestampsLastTmp[1];
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.abs(dateOne) > Math.abs(dateTwo) ? dateOne : dateTwo;
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateUtils.getDateStyle(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        DateStyle[] dateStyleArray = DateStyle.values();
        int n = dateStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            DateStyle style = dateStyleArray[n2];
            if (!style.isShowOnly()) {
                Date dateTmp = null;
                if (date != null) {
                    try {
                        ParsePosition pos = new ParsePosition(0);
                        dateTmp = DateUtils.getDateFormat(style.getValue()).parse(date, pos);
                        if (pos.getIndex() != date.length()) {
                            dateTmp = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dateTmp != null) {
                    timestamps.add(dateTmp.getTime());
                    map.put(dateTmp.getTime(), style);
                }
            }
            ++n2;
        }
        Date accurateDate = DateUtils.getAccurateDate(timestamps);
        if (accurateDate != null) {
            dateStyle = (DateStyle)((Object)map.get(accurateDate.getTime()));
        }
        return dateStyle;
    }

    public static Date StringToDate(String date) {
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToDate(date, dateStyle);
    }

    public static Date StringToDate(String date, String pattern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtils.getDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date StringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        if (dateStyle != null) {
            myDate = DateUtils.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(Date date, String pattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtils.getDateFormat(pattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtils.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String newPattern) {
        DateStyle oldDateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToString(date, oldDateStyle, newPattern);
    }

    public static String StringToString(String date, DateStyle newDateStyle) {
        DateStyle oldDateStyle = DateUtils.getDateStyle(date);
        return DateUtils.StringToString(date, oldDateStyle, newDateStyle);
    }

    public static String StringToString(String date, String olddPattern, String newPattern) {
        return DateUtils.DateToString(DateUtils.StringToDate(date, olddPattern), newPattern);
    }

    public static String StringToString(String date, DateStyle olddDteStyle, String newParttern) {
        String dateString = null;
        if (olddDteStyle != null) {
            dateString = DateUtils.StringToString(date, olddDteStyle.getValue(), newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, String olddPattern, DateStyle newDateStyle) {
        String dateString = null;
        if (newDateStyle != null) {
            dateString = DateUtils.StringToString(date, olddPattern, newDateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle != null && newDateStyle != null) {
            dateString = DateUtils.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtils.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateUtils.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int monthAmount) {
        return DateUtils.addInteger(date, 2, monthAmount);
    }

    public static Date addMonth(Date date, int monthAmount) {
        return DateUtils.addInteger(date, 2, monthAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtils.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtils.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtils.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateUtils.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int minuteAmount) {
        return DateUtils.addInteger(date, 12, minuteAmount);
    }

    public static Date addMinute(Date date, int minuteAmount) {
        return DateUtils.addInteger(date, 12, minuteAmount);
    }

    public static String addSecond(String date, int secondAmount) {
        return DateUtils.addInteger(date, 13, secondAmount);
    }

    public static Date addSecond(Date date, int secondAmount) {
        return DateUtils.addInteger(date, 13, secondAmount);
    }

    public static int getYear(String date) {
        return DateUtils.getYear(DateUtils.StringToDate(date));
    }

    public static int getYear(Date date) {
        return DateUtils.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateUtils.getMonth(DateUtils.StringToDate(date));
    }

    public static int getMonth(Date date) {
        return DateUtils.getInteger(date, 2) + 1;
    }

    public static int getDay(String date) {
        return DateUtils.getDay(DateUtils.StringToDate(date));
    }

    public static int getDay(Date date) {
        return DateUtils.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateUtils.getHour(DateUtils.StringToDate(date));
    }

    public static int getHour(Date date) {
        return DateUtils.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateUtils.getMinute(DateUtils.StringToDate(date));
    }

    public static int getMinute(Date date) {
        return DateUtils.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateUtils.getSecond(DateUtils.StringToDate(date));
    }

    public static int getSecond(Date date) {
        return DateUtils.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtils.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateUtils.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateUtils.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtils.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtils.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtils.StringToDate(date, dateStyle);
            week = DateUtils.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtils.getIntervalDays(DateUtils.StringToDate(date), DateUtils.StringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        int num = -1;
        Date dateTmp = DateUtils.StringToDate(DateUtils.getDate(date), DateStyle.YYYY_MM_DD);
        Date otherDateTmp = DateUtils.StringToDate(DateUtils.getDate(otherDate), DateStyle.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = Math.abs(dateTmp.getTime() - otherDateTmp.getTime());
            num = (int)(time / 86400000L);
        }
        return num;
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(String date) {
        return new SimpleLunarCalendar(DateUtils.StringToDate(date));
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(Date date) {
        return new SimpleLunarCalendar(date);
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getDistanceOfTodayDate(DateUtils.parseDate("2016-05-11 16:43:22")) + 1L);
    }
}

