/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.taglibs.builder;

import cn.smarthse.core.framework.taglibs.TagBuilder;
import cn.smarthse.core.framework.taglibs.TagDTO;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PageTagBuilder
implements TagBuilder {
    public static final String TOTAL_RECORDS = "totalRecords";
    public static final String TOTAL_PAGES = "totalPages";
    public static final String CURPAGE = "curPage";
    public static final String EXPORT_URL = "exportUrl";
    public static final String LOOKUP = "lookup";
    private String totalRecords;
    private String totalPages;
    private String curPage;
    private String exportUrl;
    private String lookup;

    @Override
    public String build(TagDTO dto) {
        this.totalRecords = dto.getProperty(TOTAL_RECORDS);
        this.totalPages = dto.getProperty(TOTAL_PAGES);
        this.curPage = dto.getProperty(CURPAGE);
        this.exportUrl = dto.getProperty(EXPORT_URL);
        this.lookup = dto.getProperty(LOOKUP);
        int prePage = 0;
        int nextPage = 0;
        int pageNo = 1;
        int totalPage = 1;
        try {
            pageNo = Integer.parseInt(this.curPage);
            totalPage = Integer.parseInt(this.totalPages);
            prePage = pageNo - 1;
            nextPage = pageNo + 1;
            prePage = prePage <= 0 ? 1 : prePage;
            nextPage = nextPage >= totalPage ? totalPage : nextPage;
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer content = new StringBuffer();
        content.append(this.buildPageMessage());
        if (totalPage > 1) {
            content.append(this.buildPageLink());
            if (this.lookup == null || this.lookup.equals("")) {
                content.append(this.buildPageButton());
            }
        }
        return this.wrapPageContent(content.toString());
    }

    private String buildPageMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("<td><div align='left'>");
        sb.append("\u603b\u5171<font color='red'>");
        sb.append(this.totalRecords);
        sb.append("</font>\u6761\u8bb0\u5f55&nbsp; \u5171");
        sb.append("<font color='red'>");
        sb.append(this.totalPages);
        sb.append("</font>\u9875&nbsp; \u5f53\u524d\u6240\u5728\u7b2c");
        sb.append("<font color='red'>");
        sb.append(this.curPage);
        sb.append("</font>\u9875");
        sb.append("</div></td>");
        return sb.toString();
    }

    private String buildPageLink() {
        int prePage = 0;
        int nextPage = 0;
        int pageNo = 1;
        int totalPage = 1;
        try {
            pageNo = Integer.parseInt(this.curPage);
            totalPage = Integer.parseInt(this.totalPages);
            prePage = pageNo - 1;
            nextPage = pageNo + 1;
            prePage = prePage <= 0 ? 1 : prePage;
            nextPage = nextPage >= totalPage ? totalPage : nextPage;
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<td><div class='class1_ur4'>");
        sb.append("<a href='javascript:void(0);' onClick='javascript:location.assign(jumpPage(1))' style='TEXT-DECORATION: none'>\u9996\u9875</a>&nbsp;&nbsp;");
        sb.append("<a href='javascript:void(0);' onClick='javascript:location.assign(jumpPage(").append(prePage).append("))' style='TEXT-DECORATION: none'>\u4e0a\u4e00\u9875</a>&nbsp;&nbsp;");
        sb.append("<a href='javascript:void(0);' onClick='javascript:location.assign(jumpPage(").append(nextPage).append("))' style='TEXT-DECORATION: none'>\u4e0b\u4e00\u9875</a>&nbsp;&nbsp;");
        sb.append("<a href='javascript:void(0);' onClick='javascript:location.assign(jumpPage(").append(this.totalPages).append("))' style='TEXT-DECORATION: none'>\u672b\u9875</a>");
        return sb.toString();
    }

    private String buildPageButton() {
        StringBuffer sb = new StringBuffer();
        sb.append("<td><input type='hidden' name='lastpage' value='");
        sb.append(this.totalPages);
        sb.append("'/>\u8f6c\u81f3\u7b2c");
        sb.append("<input maxLength=5 name='jumppage' size=2 value='");
        sb.append("'/>");
        sb.append("\u9875 &nbsp;&nbsp;");
        sb.append("<input type='button' name='pagesubmit' ");
        sb.append("onclick='return gotoPage()' class='button_70px' ");
        sb.append("value='\u8df3\u8f6c'/></td>");
        sb.append("<td>");
        if (StringUtils.isNotEmpty((String)this.exportUrl)) {
            sb.append("<input type='button' name='genExcel' class='button_100px' value='\u4fdd\u5b58\u6210Excel\u6587\u4ef6' onclick=\"exportExcel('");
            sb.append(this.exportUrl);
            sb.append("')\">");
        }
        sb.append("</td>");
        return sb.toString();
    }

    private String wrapPageContent(String content) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td class='td_table_bottom' colspan='8'>");
        sb.append("<table class='table-paging' border='0' cellpadding='0' cellspacing='0'><tr>");
        sb.append(content);
        sb.append("</tr></table></td></tr>");
        return sb.toString();
    }
}

