/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.taglibs.builder;

import cn.smarthse.core.framework.taglibs.TagBuilder;
import cn.smarthse.core.framework.taglibs.TagDTO;
import org.springframework.stereotype.Component;

@Component
public class DialogPageTagBuilder
implements TagBuilder {
    public static final String TOTAL_PAGES = "totalPages";
    public static final String CURPAGE = "curPage";
    public static final String EVENTNAME = "eventname";
    private String totalPages;
    private String curPage;
    private String eventname;
    private int prePage = 0;
    private int nextPage = 0;
    private int pageNo = 1;
    private int totalPage = 1;

    @Override
    public String build(TagDTO dto) {
        this.totalPages = dto.getProperty(TOTAL_PAGES);
        this.curPage = dto.getProperty(CURPAGE);
        this.eventname = dto.getProperty(EVENTNAME);
        try {
            this.pageNo = Integer.parseInt(this.curPage);
            this.totalPage = Integer.parseInt(this.totalPages);
            this.prePage = this.pageNo - 1;
            this.nextPage = this.pageNo + 1;
            this.prePage = this.prePage <= 0 ? 1 : this.prePage;
            this.nextPage = this.nextPage >= this.totalPage ? this.totalPage : this.nextPage;
        }
        catch (Exception e) {
            return "";
        }
        if (this.totalPage > 1) {
            StringBuffer content = new StringBuffer();
            if (this.pageNo > 1) {
                content.append("<li><a onclick='").append(this.eventname).append("(").append(this.prePage).append(")' href='javascript:void(0);'>\u00ab</a></li>");
            }
            int p_start = 1;
            int p_end = this.pageNo + 4;
            if (this.pageNo > 5) {
                p_start = this.pageNo - 4;
                content.append("<li><a onclick='").append(this.eventname).append("(").append(this.pageNo - 5).append(")' href='javascript:void(0);'>...</a></li>");
            }
            if (p_end > this.totalPage) {
                p_end = this.totalPage;
            }
            int i = p_start;
            while (i <= p_end) {
                if (i == this.pageNo) {
                    content.append("<li class='active'><a href='javascript:void(0);' >").append(i).append("</a></li>");
                } else {
                    content.append("<li><a  onclick='").append(this.eventname).append("(").append(i).append(")' href='javascript:void(0);'>").append(i).append("</a></li>");
                }
                ++i;
            }
            if (p_end < this.totalPage) {
                content.append("<li><a  onclick='").append(this.eventname).append("(").append(p_end + 1).append(")' href='javascript:void(0);'>...</a></li>");
            }
            if (this.pageNo < this.totalPage) {
                content.append("<li><a onclick='").append(this.eventname).append("(").append(this.nextPage).append(")' href='javascript:void(0);'>\u00bb</a></li>");
            }
            return this.wrapPageContent(content.toString());
        }
        return "";
    }

    private String wrapPageContent(String content) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class='pagination-box padding-tlbr0'>");
        sb.append("<ul class='pagination'>");
        sb.append(content);
        sb.append("</ul>");
        sb.append("<div class='jian-divbox' style='display:none'>");
        sb.append("<div class='input-group fl mr5' style='width:50px;'><input type='text' class='input-control'></div>");
        sb.append("<a href='javascript:;' class='btn btn-default btn-sm color_black fl' style='height: 22px;line-height: 22px;' title='\u8df3\u8f6c'>");
        sb.append("<span class='glyphicon glyphicon-retweet mr5'></span>\u8df3\u8f6c");
        sb.append("</a>");
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }
}

