/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.security.shiro;

import cn.smarthse.core.framework.utils.Digests;
import cn.smarthse.core.framework.utils.EncodeUtils;
import cn.smarthse.core.model.basic.User;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;

public class ShiroPasswordHelper {
    private RandomNumberGenerator randomNumberGenerator = new SecureRandomNumberGenerator();
    private String algorithmName = "SHA-1";
    private int hashIterations = 2;

    public void setRandomNumberGenerator(RandomNumberGenerator randomNumberGenerator) {
        this.randomNumberGenerator = randomNumberGenerator;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public void setHashIterations(int hashIterations) {
        this.hashIterations = hashIterations;
    }

    public void encryptPassword(User user) {
        byte[] salt = Digests.generateSalt(8);
        user.setSalt(EncodeUtils.hexEncode(salt));
        String newPassword = new SimpleHash(this.algorithmName, (Object)user.getPassword(), (Object)ByteSource.Util.bytes((String)user.getSalt()), this.hashIterations).toHex();
        user.setPassword(newPassword);
    }

    public static void main(String[] args) {
        String algorithmName = "md5";
        String username = "wang";
        String password = "111111";
        String salt1 = username;
        String salt2 = new SecureRandomNumberGenerator().nextBytes().toHex();
        int hashIterations = 3;
        SimpleHash hash = new SimpleHash(algorithmName, (Object)password, (Object)(String.valueOf(salt1) + salt2), hashIterations);
        String encodedPassword = hash.toHex();
        System.out.println(encodedPassword);
        System.out.println(salt2);
    }
}

