/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.security.shiro;

import cn.smarthse.core.model.basic.UserThirdlogin;
import cn.smarthse.core.service.MemcachedService;
import cn.smarthse.core.service.security.UserThirdLoginManager;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authc.AuthenticationFilter;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroMobileTokenAuthentication
extends AuthenticationFilter {
    public String token;
    public String userid;
    @Autowired
    protected MemcachedService memcachedService;
    @Autowired
    protected UserThirdLoginManager userTLManeger;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        this.userid = req.getHeader("userid");
        this.token = req.getHeader("token");
        if (this.isAccess(this.userid, this.token)) {
            return this.onAccessSuccess(req, (HttpServletResponse)response);
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.getOutputStream().write("Access fail".getBytes("utf-8"));
        return this.onAccessFail(req, (HttpServletResponse)response);
    }

    public boolean isAccess(String userid, String token) {
        Object userToken = this.memcachedService.getCache("abcdefg" + userid);
        if (userToken != null && userToken.toString().equals(token)) {
            return true;
        }
        if (userid != null) {
            try {
                int intUserid = Integer.parseInt(userid);
                UserThirdlogin userTL = this.userTLManeger.getUserThirdlogin(intUserid, 0, token);
                if (userTL != null) {
                    this.memcachedService.pullCache("abcdefg" + userid, userTL.getToken());
                    userTL.setUpdatedate(new Date());
                    this.userTLManeger.updateThirdlogin(userTL);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean onAccessSuccess(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public boolean onAccessFail(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }
}

