/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.security.shiro;

import cn.smarthse.core.model.security.SecResource;
import cn.smarthse.core.service.security.PermissionManager;
import cn.smarthse.core.service.security.ResourceManager;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.config.Ini;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroDefinitionSectionMetaSource
implements FactoryBean<Ini.Section> {
    private static Log log = LogFactory.getLog(ShiroDefinitionSectionMetaSource.class);
    @Autowired
    private ResourceManager resourceManager;
    @Autowired
    private PermissionManager permissionManager;
    private String filterChainDefinitions;
    public static final String PREMISSION_FORMAT = "perms[\"{0}\"]";

    public Ini.Section getObject() throws Exception {
        Ini ini = new Ini();
        ini.load(this.filterChainDefinitions);
        Ini.Section section = ini.getSection("");
        List<SecResource> resources = this.resourceManager.getAll();
        for (SecResource resource : resources) {
            this.putDefinitionSection(section, resource.getResourcename(), resource.getLink());
        }
        section.put("/**", "user");
        return section;
    }

    private void putDefinitionSection(Ini.Section section, String key, String value) {
        section.put(key, MessageFormat.format(PREMISSION_FORMAT, value));
    }

    public void setFilterChainDefinitions(String filterChainDefinitions) {
        this.filterChainDefinitions = filterChainDefinitions;
    }

    public Class<?> getObjectType() {
        return this.getClass();
    }

    public boolean isSingleton() {
        return false;
    }
}

