/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.security.shiro;

import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.Message;
import cn.smarthse.core.framework.security.shiro.ShiroPrincipal;
import cn.smarthse.core.framework.security.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.core.framework.utils.EncodeUtils;
import cn.smarthse.core.model.basic.User;
import cn.smarthse.core.service.MemcachedService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.security.UserManager;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroAuthorizingRealm
extends AuthorizingRealm {
    private static Logger log = LoggerFactory.getLogger(ShiroAuthorizingRealm.class);
    @Autowired
    private UserManager userManager;
    @Autowired
    private StaffService staffService;
    @Autowired
    private MemcachedService memcachedService;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public ShiroAuthorizingRealm() {
        this.setAuthenticationTokenClass(ShiroUsernamePasswordToken.class);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        ShiroPrincipal subject = (ShiroPrincipal)super.getAvailablePrincipal(principals);
        String username = subject.getUsername();
        Integer userId = subject.getId();
        log.info("\u7528\u6237\u3010" + username + "\u3011\u6388\u6743\u5f00\u59cb......");
        try {
            if (!subject.isAuthorized()) {
                List<String> authorities = this.userManager.getPermissionName(userId);
                List<String> rolelist = this.userManager.getRolesName(userId);
                subject.setAuthorities(authorities);
                subject.setRoles(rolelist);
                subject.setAuthorized(true);
                log.info("\u7528\u6237\u3010" + username + "\u3011\u6388\u6743\u521d\u59cb\u5316\u6210\u529f......");
                log.info("\u7528\u6237\u3010" + username + "\u3011 \u89d2\u8272\u5217\u8868\u4e3a\uff1a" + subject.getRoles());
                log.info("\u7528\u6237\u3010" + username + "\u3011 \u6743\u9650\u5217\u8868\u4e3a\uff1a" + subject.getAuthorities());
            } else {
                log.info("\u7528\u6237\u3010" + username + "\u3011\u5df2\u6388\u6743......");
            }
        }
        catch (RuntimeException e) {
            throw new AuthorizationException("\u7528\u6237\u3010" + username + "\u3011\u6388\u6743\u5931\u8d25");
        }
        info.addStringPermissions(subject.getAuthorities());
        info.addRoles(subject.getRoles());
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        ShiroUsernamePasswordToken upToken = (ShiroUsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (StringUtils.isEmpty((String)username)) {
            throw new AccountException(Message.bundle.getString("username_cannotbe_null"));
        }
        if (upToken.getLoginType() == 2) {
            if (StringUtils.isEmpty((String)upToken.getCaptcha())) {
                throw new AuthenticationException("\u56fe\u5f62\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String capText = (String)SecurityUtils.getSubject().getSession().getAttribute((Object)"login_captcha");
            if (!upToken.getCaptcha().equals(capText)) {
                throw new AuthenticationException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
        } else if (upToken.getLoginType() == 3) {
            if (StringUtils.isEmpty((String)upToken.getVcode())) {
                throw new AuthenticationException("\u52a8\u6001\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String cacheName = "MobileLoginVcodeCache" + username;
            String cachecode = (String)this.memcachedService.getCache(cacheName);
            if (!"0000".equals(upToken.getVcode()) && !upToken.getVcode().equals(cachecode)) {
                throw new AuthenticationException("\u52a8\u6001\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
        } else if (upToken.getLoginType() != 4) {
            upToken.getLoginType();
        }
        User user = null;
        try {
            user = this.userManager.getByName(username);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (user == null) {
            throw new IncorrectCredentialsException(Message.bundle.getString("user_not_exist"));
        }
        if (user.getIsvalid() == null || !Constant.ACTIVE_YES.equals(user.getIsvalid())) {
            throw new IncorrectCredentialsException(Message.bundle.getString("user_forbidden"));
        }
        byte[] salt = EncodeUtils.hexDecode(user.getSalt());
        ShiroPrincipal subject = new ShiroPrincipal(user);
        subject.setStaff(this.staffService.selectByUserId(user.getId()));
        return new SimpleAuthenticationInfo((Object)subject, (Object)user.getPassword(), ByteSource.Util.bytes((byte[])salt), this.getName());
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    protected void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        ShiroUsernamePasswordToken token = (ShiroUsernamePasswordToken)authcToken;
        if (token.getLoginType() != 2) {
            if (token.getLoginType() == 3) {
                return;
            }
            if (token.getLoginType() == 4) {
                return;
            }
            token.getLoginType();
        }
        super.assertCredentialsMatch((AuthenticationToken)token, info);
    }

    public void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        super.clearCachedAuthorizationInfo(principals);
    }

    public void clearCachedAuthenticationInfo(PrincipalCollection principals) {
        super.clearCachedAuthenticationInfo(principals);
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }

    public void clearAllCachedAuthorizationInfo() {
        this.getAuthorizationCache().clear();
    }

    public void clearAllCachedAuthenticationInfo() {
        this.getAuthenticationCache().clear();
    }

    public void clearAllCache() {
        this.clearAllCachedAuthenticationInfo();
        this.clearAllCachedAuthorizationInfo();
    }
}

