/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.security.shiro;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;

public class ShiroAuthorizingCredentialsMatcher
extends HashedCredentialsMatcher {
    private Cache<String, AtomicInteger> passwordRetryCache;
    private int retryCount = 5;

    public ShiroAuthorizingCredentialsMatcher(CacheManager cacheManager) {
        this.passwordRetryCache = cacheManager.getCache("passwordRetryCache");
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        String username = (String)token.getPrincipal();
        AtomicInteger retryCount = (AtomicInteger)this.passwordRetryCache.get((Object)username);
        if (retryCount == null) {
            retryCount = new AtomicInteger(0);
            this.passwordRetryCache.put((Object)username, (Object)retryCount);
        }
        if (retryCount.incrementAndGet() > 5) {
            throw new ExcessiveAttemptsException();
        }
        boolean matches = super.doCredentialsMatch(token, info);
        if (matches) {
            this.passwordRetryCache.remove((Object)username);
        }
        return matches;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

