/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.orm;

import cn.smarthse.core.framework.utils.ConvertUtils;
import cn.smarthse.core.framework.utils.ServletUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class PropertyFilter {
    public static final String OR_SEPARATOR = "_OR_";
    private MatchType matchType = null;
    private Object matchValue = null;
    private Class<?> propertyClass = null;
    private String[] propertyNames = null;

    public PropertyFilter() {
    }

    public PropertyFilter(String filterName, String value) {
        String firstPart = StringUtils.substringBefore((String)filterName, (String)"_");
        String matchTypeCode = StringUtils.substring((String)firstPart, (int)0, (int)(firstPart.length() - 1));
        String propertyTypeCode = StringUtils.substring((String)firstPart, (int)(firstPart.length() - 1), (int)firstPart.length());
        try {
            this.matchType = Enum.valueOf(MatchType.class, matchTypeCode);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u6bd4\u8f83\u7c7b\u578b.", e);
        }
        try {
            this.propertyClass = Enum.valueOf(PropertyType.class, propertyTypeCode).getValue();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u503c\u7c7b\u578b.", e);
        }
        String propertyNameStr = StringUtils.substringAfter((String)filterName, (String)"_");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)propertyNameStr), (String)("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u540d\u79f0."));
        this.propertyNames = StringUtils.splitByWholeSeparator((String)propertyNameStr, (String)OR_SEPARATOR);
        this.matchValue = ConvertUtils.convertStringToObject(value, this.propertyClass);
    }

    public static List<PropertyFilter> buildFromHttpRequest(HttpServletRequest request) {
        return PropertyFilter.buildFromHttpRequest(request, "filter");
    }

    public static List<PropertyFilter> buildFromHttpRequest(HttpServletRequest request, String filterPrefix) {
        ArrayList<PropertyFilter> filterList = new ArrayList<PropertyFilter>();
        Map<String, Object> filterParamMap = ServletUtils.getParametersStartingWith((ServletRequest)request, String.valueOf(filterPrefix) + "_");
        for (Map.Entry<String, Object> entry : filterParamMap.entrySet()) {
            String filterName = entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            PropertyFilter filter = new PropertyFilter(filterName, value);
            filterList.add(filter);
        }
        return filterList;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public Object getMatchValue() {
        return this.matchValue;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getPropertyName() {
        Assert.isTrue((this.propertyNames.length == 1 ? 1 : 0) != 0, (String)"There are not only one property in this filter.");
        return this.propertyNames[0];
    }

    public boolean hasMultiProperties() {
        return this.propertyNames.length > 1;
    }

    public static enum MatchType {
        EQ,
        LIKE,
        LT,
        GT,
        LE,
        GE;

    }

    public static enum PropertyType {
        S(String.class),
        I(Integer.class),
        L(Long.class),
        N(Double.class),
        D(Date.class),
        B(Boolean.class);

        private Class<?> clazz;

        private PropertyType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getValue() {
            return this.clazz;
        }
    }
}

