/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.orm;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Page2<T> {
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    public static final int NON_PAGE = 0;
    protected int pageNo = 1;
    protected int pageSize = -1;
    protected String orderBy = null;
    protected String order = null;
    protected boolean autoCount = true;
    protected List<T> result = Lists.newArrayList();
    protected long totalCount = -1L;

    public Page2() {
        this.pageSize = 10;
    }

    public Page2(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public Page2<T> pageNo(int thePageNo) {
        this.setPageNo(thePageNo);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Page2<T> pageSize(int thePageSize) {
        this.setPageSize(thePageSize);
        return this;
    }

    public int getFirst() {
        return (this.pageNo - 1) * this.pageSize + 1;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Page2<T> orderBy(String theOrderBy) {
        this.setOrderBy(theOrderBy);
        return this;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        String[] orders;
        String lowcaseOrder = StringUtils.lowerCase((String)order);
        String[] stringArray = orders = StringUtils.split((String)lowcaseOrder, (char)',');
        int n = orders.length;
        int n2 = 0;
        while (n2 < n) {
            String orderStr = stringArray[n2];
            if (!StringUtils.equals((String)DESC, (String)orderStr) && !StringUtils.equals((String)ASC, (String)orderStr)) {
                throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + orderStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
            }
            ++n2;
        }
        this.order = lowcaseOrder;
    }

    public Page2<T> order(String theOrder) {
        this.setOrder(theOrder);
        return this;
    }

    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((String)this.orderBy) && StringUtils.isNotBlank((String)this.order);
    }

    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public Page2<T> autoCount(boolean theAutoCount) {
        this.setAutoCount(theAutoCount);
        return this;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        if (this.totalCount < 0L) {
            return -1L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public boolean isHasNext() {
        return (long)(this.pageNo + 1) <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.isHasNext()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    public boolean isHasPre() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrePage() {
        if (this.isHasPre()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }
}

