/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util.lambdaj.demo;

import ch.lambdaj.Lambda;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableMain {
    private static Random random = new Random(0L);
    private static final int BEAN_NUMBER = 10;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 600, 440);
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.setOpaque(true);
        frame.setContentPane(panel);
        ArrayList<Bean> model = new ArrayList<Bean>();
        int i = 0;
        while (i < 10) {
            model.add(new Bean(true));
            ++i;
        }
        JTable table = new JTable(new LambdajTableModel(model));
        table.setPreferredScrollableViewportSize(new Dimension(600, 440));
        table.setFillsViewportHeight(true);
        panel.add(new JScrollPane(table));
        table.setRowHeight(40);
        TableColumnModel tcm = table.getColumnModel();
        int i2 = 0;
        while (i2 < table.getModel().getColumnCount()) {
            tcm.getColumn(i2).setCellRenderer(new LambdajCellRenderer());
            ++i2;
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static class Bean {
        private int a;
        private int b;
        private int c;

        public Bean() {
            this(false);
        }

        public Bean(boolean initValues) {
            if (initValues) {
                this.a = random.nextInt(1000);
                this.b = random.nextInt(1000);
                this.c = random.nextInt(1000);
            }
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }
    }

    private static class LambdajCellRenderer
    extends DefaultTableCellRenderer {
        Font font = new Font("Helvetica Bold", 1, 32);

        private LambdajCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                if (column > 0) {
                    label.setHorizontalAlignment(4);
                }
                label.setFont(this.font);
            }
            return label;
        }
    }

    private static class LambdajTableModel
    extends AbstractTableModel {
        private final List<Bean> model;

        LambdajTableModel(List<Bean> beans) {
            this.model = new ArrayList<Bean>(beans);
            this.model.add((Bean)Lambda.sumFrom(beans));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getRowName(rowIndex);
            }
            Bean bean = this.model.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    return bean.getA();
                }
                case 2: {
                    return bean.getB();
                }
                case 3: {
                    return bean.getC();
                }
            }
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Integer.class;
        }

        private String getRowName(int rowIndex) {
            return rowIndex == 10 ? "Totals" : "Bean " + rowIndex;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Object";
                }
                case 1: {
                    return "A";
                }
                case 2: {
                    return "B";
                }
                case 3: {
                    return "C";
                }
            }
            return "";
        }
    }
}

