/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util.lambdaj.demo;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaCollections;
import ch.lambdaj.collection.LambdaGroup;
import ch.lambdaj.collection.LambdaList;
import ch.lambdaj.collection.LambdaMap;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Car;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Db;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Person;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Sale;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LambdaListDemoTest {
    private final Db db = Db.getInstance();

    @Test
    public void testPrintAllBrands() {
        StringBuilder sb = new StringBuilder();
        for (Car car : this.db.getCars()) {
            sb.append(car.getBrand()).append(", ");
        }
        String brandsIterative = sb.toString().substring(0, sb.length() - 2);
        String brands = LambdaCollections.with(this.db.getCars()).extract((Object)((Car)Lambda.on(Car.class)).getBrand()).join();
        Assert.assertEquals((Object)brandsIterative, (Object)brands);
        String brands2 = ((Car)LambdaCollections.with(this.db.getCars()).joinFrom()).getBrand();
        Assert.assertEquals((Object)brandsIterative, (Object)brands2);
    }

    @Test
    public void testFindAllSalesOfAFerrari() {
        ArrayList<Sale> salesIterative = new ArrayList<Sale>();
        for (Sale sale : this.db.getSales()) {
            if (!sale.getCar().getBrand().equals("Ferrari")) continue;
            salesIterative.add(sale);
        }
        LambdaList sales = LambdaCollections.with(this.db.getSales()).clone().retain((Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getCar().getBrand(), (Matcher)Matchers.equalTo((Object)"Ferrari")));
        Assert.assertTrue((boolean)Util.listsAreEqual(sales, salesIterative));
    }

    @Test
    public void testFindAllBuysOfYoungestPerson() {
        Person youngest = null;
        for (Person person : this.db.getPersons()) {
            if (youngest != null && person.getAge() >= youngest.getAge()) continue;
            youngest = person;
        }
        ArrayList<Sale> salesIterative = new ArrayList<Sale>();
        for (Sale sale : this.db.getSales()) {
            if (!sale.getBuyer().equals(youngest)) continue;
            salesIterative.add(sale);
        }
        Person lambdaYoungest = (Person)LambdaCollections.with(this.db.getPersons()).selectMin((Object)((Person)Lambda.on(Person.class)).getAge());
        LambdaList sales = LambdaCollections.with(this.db.getSales()).clone().retain((Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getBuyer(), (Matcher)Matchers.equalTo((Object)lambdaYoungest)));
        Assert.assertTrue((boolean)Util.listsAreEqual(sales, salesIterative));
    }

    @Test
    public void testFindMostCostlySaleValue() {
        double maxCost = 0.0;
        for (Sale sale : this.db.getSales()) {
            double cost = sale.getCost();
            if (!(cost > maxCost)) continue;
            maxCost = cost;
        }
        double max = ((Sale)LambdaCollections.with(this.db.getSales()).maxFrom()).getCost();
        Assert.assertEquals((double)max, (double)maxCost, (double)0.001);
        double max2 = (Double)LambdaCollections.with(this.db.getSales()).max((Object)((Sale)Lambda.on(Sale.class)).getCost());
        Assert.assertEquals((double)max2, (double)maxCost, (double)0.001);
    }

    @Test
    public void testSumSalesCostWhereBothActorsAreAMale() {
        double sumIterative = 0.0;
        for (Sale sale : this.db.getSales()) {
            if (!sale.getBuyer().isMale() || !sale.getSeller().isMale()) continue;
            sumIterative += sale.getCost();
        }
        double sum = ((Sale)LambdaCollections.with(this.db.getSales()).clone().retain((Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getBuyer().isMale()).and((Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getSeller().isMale()))).sumFrom()).getCost();
        Assert.assertEquals((double)sum, (double)sumIterative, (double)0.001);
        double sum2 = (Double)LambdaCollections.with(this.db.getSales()).clone().retain((Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getBuyer().isMale())).retain((Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getSeller().isMale())).sum((Object)((Sale)Lambda.on(Sale.class)).getCost());
        Assert.assertEquals((double)sum2, (double)sumIterative, (double)0.001);
    }

    @Test
    public void testFindYoungestAgeOfWhoBoughtACarForMoreThan50000() {
        int ageIterative = Integer.MAX_VALUE;
        for (Sale sale : this.db.getSales()) {
            int buyerAge;
            if (!(sale.getCost() > 50000.0) || (buyerAge = sale.getBuyer().getAge()) >= ageIterative) continue;
            ageIterative = buyerAge;
        }
        int age = (Integer)Lambda.min((Object)((Sale)LambdaCollections.with(this.db.getSales()).forEach((Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getCost(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(50000.0))))).getBuyer(), (Object)((Person)Lambda.on(Person.class)).getAge());
        Assert.assertEquals((long)age, (long)ageIterative);
    }

    @Test
    public void testSortSalesByCost() {
        ArrayList<Sale> sortedSalesIterative = new ArrayList<Sale>(this.db.getSales());
        Collections.sort(sortedSalesIterative, new Comparator<Sale>(){

            @Override
            public int compare(Sale s1, Sale s2) {
                return Double.valueOf(s1.getCost()).compareTo(s2.getCost());
            }
        });
        LambdaList sortedSales = LambdaCollections.with(this.db.getSales()).clone().sort((Object)((Sale)Lambda.on(Sale.class)).getCost());
        Assert.assertTrue((boolean)Util.listsAreEqual(sortedSales, sortedSalesIterative));
    }

    @Test
    public void testExtractCarsOriginalCost() {
        ArrayList<Double> costsIterative = new ArrayList<Double>();
        for (Car car : this.db.getCars()) {
            costsIterative.add(car.getOriginalValue());
        }
        LambdaList costs = LambdaCollections.with(this.db.getCars()).extract((Object)((Car)Lambda.on(Car.class)).getOriginalValue());
        Assert.assertTrue((boolean)Util.listsAreEqual(costs, costsIterative));
    }

    @Test
    public void testIndexCarsByBrand() {
        HashMap<String, Car> carsByBrandIterative = new HashMap<String, Car>();
        for (Car car : this.db.getCars()) {
            carsByBrandIterative.put(car.getBrand(), car);
        }
        LambdaMap carsByBrand = LambdaCollections.with(this.db.getCars()).index((Object)((Car)Lambda.on(Car.class)).getBrand());
        Assert.assertEquals(carsByBrand.get("Ferrari"), carsByBrandIterative.get("Ferrari"));
    }

    @Test
    public void testGroupSalesByBuyersAndSellers() {
        Person youngestPerson = null;
        Person oldestPerson = null;
        for (Person person : this.db.getPersons()) {
            if (youngestPerson == null || person.getAge() < youngestPerson.getAge()) {
                youngestPerson = person;
            }
            if (oldestPerson != null && person.getAge() <= oldestPerson.getAge()) continue;
            oldestPerson = person;
        }
        HashMap<Person, HashMap<Person, Sale>> map = new HashMap<Person, HashMap<Person, Sale>>();
        for (Sale sale : this.db.getSales()) {
            Person buyer = sale.getBuyer();
            HashMap<Person, Sale> buyerMap = (HashMap<Person, Sale>)map.get(buyer);
            if (buyerMap == null) {
                buyerMap = new HashMap<Person, Sale>();
                map.put(buyer, buyerMap);
            }
            buyerMap.put(sale.getSeller(), sale);
        }
        Sale saleIterative = (Sale)((Map)map.get(youngestPerson)).get(oldestPerson);
        Person youngest = (Person)LambdaCollections.with(this.db.getPersons()).selectMin((Object)((Person)Lambda.on(Person.class)).getAge());
        Person oldest = (Person)LambdaCollections.with(this.db.getPersons()).selectMax((Object)((Person)Lambda.on(Person.class)).getAge());
        LambdaGroup group = LambdaCollections.with(this.db.getSales()).group(new GroupCondition[]{Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getBuyer()), Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getSeller())});
        Sale sale = (Sale)group.findGroup((Object)youngest).find((Object)oldest).get(0);
        Assert.assertEquals((Object)sale, (Object)saleIterative);
    }

    @Test
    public void testGroupSalesByBuyersSortedByAge() {
        TreeMap<Person, ArrayList<Sale>> map = new TreeMap<Person, ArrayList<Sale>>(new Comparator<Person>(){

            @Override
            public int compare(Person p1, Person p2) {
                return p1.getAge() - p2.getAge();
            }
        });
        for (Sale sale : this.db.getSales()) {
            Person buyer = sale.getBuyer();
            ArrayList<Sale> sales = (ArrayList<Sale>)map.get(buyer);
            if (sales == null) {
                sales = new ArrayList<Sale>();
                map.put(buyer, sales);
            }
            sales.add(sale);
        }
        LambdaGroup group = LambdaCollections.with(this.db.getSales()).group(new GroupCondition[]{Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getBuyer()).sort((Comparable)Integer.valueOf(((Person)Lambda.on(Person.class)).getAge()))});
        Iterator groupIterator = group.subgroups().iterator();
        for (List iterativeSales : map.values()) {
            List lambdajSales = ((Group)groupIterator.next()).findAll();
            Assert.assertTrue((boolean)iterativeSales.containsAll(lambdajSales));
            Assert.assertTrue((boolean)lambdajSales.containsAll(iterativeSales));
        }
    }

    @Test
    public void testFindMostBoughtCar() {
        LinkedHashMap<Car, Integer> carsBought = new LinkedHashMap<Car, Integer>();
        for (Sale sale : this.db.getSales()) {
            Car car;
            Integer boughtTimes = (Integer)carsBought.get(car = sale.getCar());
            carsBought.put(car, boughtTimes == null ? 1 : boughtTimes + 1);
        }
        Car mostBoughtCarIterative = null;
        int boughtTimesIterative = 0;
        for (Map.Entry entry : carsBought.entrySet()) {
            if ((Integer)entry.getValue() <= boughtTimesIterative) continue;
            mostBoughtCarIterative = (Car)entry.getKey();
            boughtTimesIterative = (Integer)entry.getValue();
        }
        Group group = (Group)LambdaCollections.with(this.db.getSales()).group(new GroupCondition[]{Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getCar())}).subgroups().selectMax((Object)((Group)Lambda.on(Group.class)).getSize());
        Car mostBoughtCar = ((Sale)group.first()).getCar();
        int boughtTimes = group.getSize();
        Assert.assertEquals((long)boughtTimesIterative, (long)boughtTimes);
        System.out.println("mostBoughtCarIterative = " + mostBoughtCarIterative);
        System.out.println("mostBoughtCar = " + mostBoughtCar);
    }
}

