/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util.lambdaj.demo;

import ch.lambdaj.Lambda;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Car;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Db;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Person;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Sale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class LambdaDemoTestMain {
    private static final int REPETITIONS = 1;
    private static final int ITERATIONS = 100000;
    private static final int TESTS_NR = 11;
    private static long[][] iterative;
    private static long[][] lambdaj;
    private static final Db db;

    static {
        db = Db.getInstance();
    }

    public static void main(String[] args) {
        int repetitions = 1;
        if (args.length == 1) {
            repetitions = Integer.parseInt(args[0]);
        }
        LambdaDemoTestMain.init(repetitions);
        int i = 0;
        while (i < repetitions) {
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testPrintAllBrands(), i, 0);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testFindAllSalesOfAFerrari(), i, 1);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testFindAllBuysOfYoungestPerson(), i, 2);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testFindMostCostlySaleValue(), i, 3);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testSumSalesCostWhereBothActorsAreAMale(), i, 4);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testFindYoungestAgeOfWhoBoughtACarForMoreThan50000(), i, 5);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testSortSalesByCost(), i, 6);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testExtractCarsOriginalCost(), i, 7);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testIndexCarsByBrand(), i, 8);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testGroupSalesByBuyersAndSellers(), i, 9);
            LambdaDemoTestMain.collectDurations(LambdaDemoTestMain.testFindMostBoughtCar(), i, 10);
            ++i;
        }
        LambdaDemoTestMain.resume(repetitions);
    }

    private static void collectDurations(long[] durations, int repetition, int index) {
        LambdaDemoTestMain.iterative[index][repetition] = durations[0];
        LambdaDemoTestMain.lambdaj[index][repetition] = durations[1];
    }

    private static void init(int repetitions) {
        iterative = new long[11][repetitions];
        lambdaj = new long[11][repetitions];
        int i = 0;
        while (i < 11) {
            int j = 0;
            while (j < repetitions) {
                LambdaDemoTestMain.iterative[i][j] = 0L;
                LambdaDemoTestMain.lambdaj[i][j] = 0L;
                ++j;
            }
            ++i;
        }
    }

    private static void resume(int repetitions) {
        int i = 0;
        while (i < 11) {
            long minIterative = (Long)Lambda.min(LambdaDemoTestMain.asLongList(iterative[i]));
            long maxIterative = (Long)Lambda.max(LambdaDemoTestMain.asLongList(iterative[i]));
            long avgIterative = Lambda.sum(LambdaDemoTestMain.asLongList(iterative[i])).longValue() / (long)repetitions;
            long minLambdaj = (Long)Lambda.min(LambdaDemoTestMain.asLongList(lambdaj[i]));
            long maxLambdaj = (Long)Lambda.max(LambdaDemoTestMain.asLongList(lambdaj[i]));
            long avgLambdaj = Lambda.sum(LambdaDemoTestMain.asLongList(lambdaj[i])).longValue() / (long)repetitions;
            System.out.println(String.valueOf(minIterative) + ";" + maxIterative + ";" + avgIterative + ";" + minLambdaj + ";" + maxLambdaj + ";" + avgLambdaj);
            ++i;
        }
    }

    private static List<Long> asLongList(long[] array) {
        ArrayList<Long> list = new ArrayList<Long>();
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long item = lArray[n2];
            list.add(item);
            ++n2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static long[] testPrintAllBrands() {
        void var4_8;
        System.out.println("*** testPrintAllBrands");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            StringBuilder sb = new StringBuilder();
            for (Car car : db.getCars()) {
                sb.append(car.getBrand()).append(", ");
            }
            String string = sb.substring(0, sb.length() - 2).toString();
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        boolean bl = false;
        while (var4_8 < 100000) {
            String string = ((Car)Lambda.joinFrom(db.getCars())).getBrand();
            ++var4_8;
        }
        long l = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + l + " msecs");
        return new long[]{duration1, l};
    }

    private static long[] testFindAllSalesOfAFerrari() {
        System.out.println("*** testFindAllSalesOfAFerrari");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            ArrayList<Sale> salesIterative = new ArrayList<Sale>();
            for (Sale sale : db.getSales()) {
                if (!sale.getCar().getBrand().equals("Ferrari")) continue;
                salesIterative.add(sale);
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            List list = Lambda.select(db.getSales(), (Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getCar().getBrand(), (Matcher)Matchers.equalTo((Object)"Ferrari")));
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testFindAllBuysOfYoungestPerson() {
        System.out.println("*** testFindAllBuysOfYoungestPerson");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            Person youngest = null;
            for (Person person : db.getPersons()) {
                if (youngest != null && person.getAge() >= youngest.getAge()) continue;
                youngest = person;
            }
            ArrayList<Sale> salesIterative = new ArrayList<Sale>();
            for (Sale sale : db.getSales()) {
                if (!sale.getBuyer().equals(youngest)) continue;
                salesIterative.add(sale);
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            List list = Lambda.select(db.getSales(), (Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getBuyer(), (Matcher)Matchers.equalTo((Object)Lambda.selectMin(db.getPersons(), (Object)((Person)Lambda.on(Person.class)).getAge()))));
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testFindMostCostlySaleValue() {
        System.out.println("*** testFindMostCostlySaleValue");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            double maxCost = 0.0;
            for (Sale sale : db.getSales()) {
                double cost = sale.getCost();
                if (!(cost > maxCost)) continue;
                maxCost = cost;
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            double d = (Double)Lambda.max(db.getSales(), (Object)((Sale)Lambda.on(Sale.class)).getCost());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testSumSalesCostWhereBothActorsAreAMale() {
        System.out.println("*** testSumSalesCostWhereBothActorsAreAMale");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            double sumIterative = 0.0;
            for (Sale sale : db.getSales()) {
                if (!sale.getBuyer().isMale() || !sale.getSeller().isMale()) continue;
                sumIterative += sale.getCost();
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            double d = (Double)Lambda.sum((Object)Lambda.select(db.getSales(), (Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getBuyer().isMale()).and((Matcher)Lambda.having((Boolean)((Sale)Lambda.on(Sale.class)).getSeller().isMale()))), (Object)((Sale)Lambda.on(Sale.class)).getCost());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testFindYoungestAgeOfWhoBoughtACarForMoreThan50000() {
        System.out.println("*** testFindYoungestAgeOfWhoBoughtACarForMoreThan50000");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            int ageIterative = Integer.MAX_VALUE;
            for (Sale sale : db.getSales()) {
                int buyerAge;
                if (!(sale.getCost() > 50000.0) || (buyerAge = sale.getBuyer().getAge()) >= ageIterative) continue;
                ageIterative = buyerAge;
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            int n = (Integer)Lambda.min((Object)((Sale)Lambda.forEach((Iterable)Lambda.select(db.getSales(), (Matcher)Lambda.having((Object)((Sale)Lambda.on(Sale.class)).getCost(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(50000.0)))))).getBuyer(), (Object)((Person)Lambda.on(Person.class)).getAge());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testSortSalesByCost() {
        System.out.println("*** testSortSalesByCost");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            ArrayList<Sale> sortedSalesIterative = new ArrayList<Sale>(db.getSales());
            Collections.sort(sortedSalesIterative, new Comparator<Sale>(){

                @Override
                public int compare(Sale s1, Sale s2) {
                    return Double.valueOf(s1.getCost()).compareTo(s2.getCost());
                }
            });
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            List list = Lambda.sort(db.getSales(), (Object)((Sale)Lambda.on(Sale.class)).getCost());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testExtractCarsOriginalCost() {
        System.out.println("*** testExtractCarsOriginalCost");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            ArrayList<Double> costsIterative = new ArrayList<Double>();
            for (Car car : db.getCars()) {
                costsIterative.add(car.getOriginalValue());
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            List list = Lambda.extract(db.getCars(), (Object)((Car)Lambda.on(Car.class)).getOriginalValue());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testIndexCarsByBrand() {
        System.out.println("*** testIndexCarsByBrand");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            HashMap<String, Car> carsByBrandIterative = new HashMap<String, Car>();
            for (Car car : db.getCars()) {
                carsByBrandIterative.put(car.getBrand(), car);
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            Map map = Lambda.index(db.getCars(), (Object)((Car)Lambda.on(Car.class)).getBrand());
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testGroupSalesByBuyersAndSellers() {
        System.out.println("*** testGroupSalesByBuyersAndSellers");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            Sale sale2;
            Person youngestPerson = null;
            Person oldestPerson = null;
            for (Person person : db.getPersons()) {
                if (youngestPerson == null || person.getAge() < youngestPerson.getAge()) {
                    youngestPerson = person;
                }
                if (oldestPerson != null && person.getAge() <= oldestPerson.getAge()) continue;
                oldestPerson = person;
            }
            HashMap<Person, HashMap<Person, Sale>> map = new HashMap<Person, HashMap<Person, Sale>>();
            for (Sale sale2 : db.getSales()) {
                Person buyer = sale2.getBuyer();
                HashMap<Person, Sale> buyerMap = (HashMap<Person, Sale>)map.get(buyer);
                if (buyerMap == null) {
                    buyerMap = new HashMap<Person, Sale>();
                    map.put(buyer, buyerMap);
                }
                buyerMap.put(sale2.getSeller(), sale2);
            }
            sale2 = (Sale)((Map)map.get(youngestPerson)).get(oldestPerson);
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            Person youngest = (Person)Lambda.selectMin(db.getPersons(), (Object)((Person)Lambda.on(Person.class)).getAge());
            Person oldest = (Person)Lambda.selectMax(db.getPersons(), (Object)((Person)Lambda.on(Person.class)).getAge());
            Group group = Lambda.group(db.getSales(), (GroupCondition[])new GroupCondition[]{Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getBuyer()), Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getSeller())});
            Sale sale = (Sale)group.findGroup((Object)youngest).find((Object)oldest).get(0);
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }

    private static long[] testFindMostBoughtCar() {
        System.out.println("*** testFindMostBoughtCar");
        long start = System.nanoTime();
        int i = 0;
        while (i < 100000) {
            LinkedHashMap<Car, Integer> carsBought = new LinkedHashMap<Car, Integer>();
            for (Sale sale : db.getSales()) {
                Car car;
                Integer boughtTimes = (Integer)carsBought.get(car = sale.getCar());
                carsBought.put(car, boughtTimes == null ? 1 : boughtTimes + 1);
            }
            Car mostBoughtCarIterative = null;
            int boughtTimesIterative = 0;
            for (Map.Entry entry : carsBought.entrySet()) {
                if ((Integer)entry.getValue() <= boughtTimesIterative) continue;
                mostBoughtCarIterative = (Car)entry.getKey();
                boughtTimesIterative = (Integer)entry.getValue();
            }
            ++i;
        }
        long duration1 = (System.nanoTime() - start) / 1000000L;
        System.out.println("iterative: " + duration1 + " msecs");
        start = System.nanoTime();
        int i2 = 0;
        while (i2 < 100000) {
            Group group = (Group)Lambda.selectMax((Object)Lambda.group(db.getSales(), (GroupCondition[])new GroupCondition[]{Lambda.by((Object)((Sale)Lambda.on(Sale.class)).getCar())}).subgroups(), (Object)((Group)Lambda.on(Group.class)).getSize());
            Car mostBoughtCar = ((Sale)group.first()).getCar();
            int n = group.getSize();
            ++i2;
        }
        long duration2 = (System.nanoTime() - start) / 1000000L;
        System.out.println("lambdaj: " + duration2 + " msecs");
        return new long[]{duration1, duration2};
    }
}

