/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util.lambdaj.demo;

import cn.smarthse.core.framework.common.util.lambdaj.demo.Car;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Person;
import cn.smarthse.core.framework.common.util.lambdaj.demo.Sale;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Db {
    public final List<Person> persons = new ArrayList<Person>();
    public final List<Car> cars = new ArrayList<Car>();
    public final List<Sale> sales = new ArrayList<Sale>();
    private static final Db DB_INSTANCE = new Db();

    public static Db getInstance() {
        return DB_INSTANCE;
    }

    public List<Person> getPersons() {
        return this.persons;
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public List<Sale> getSales() {
        return this.sales;
    }

    private Db() {
        this.createPersons();
        this.createCars();
        this.createSales();
    }

    private void createPersons() {
        this.persons.add(new Person("Mario", "Fusco", true, "18/03/1974"));
        this.persons.add(new Person("Irma", "Fusco", false, "04/06/1978"));
        this.persons.add(new Person("Domenico", "Fusco", true, "10/06/1939"));
        this.persons.add(new Person("Ernestina", "Di Landa", false, "06/10/1949"));
        this.persons.add(new Person("Marilena", "Marrese", false, "14/04/1972"));
        this.persons.add(new Person("Biagio", "Beatrice", true, "19/04/1970"));
        this.persons.add(new Person("Celestino", "Bellone", true, "03/01/1981"));
        this.persons.add(new Person("Luca", "Marrocco", true, "07/12/1980"));
    }

    private void createCars() {
        this.cars.add(new Car("Fiat", "Panda", 2003, 7500.0));
        this.cars.add(new Car("Lancia", "Delta", 1992, 19000.0));
        this.cars.add(new Car("Alfa Romeo", "8c", 2007, 145000.0));
        this.cars.add(new Car("Ferrari", "Enzo", 2004, 650000.0));
        this.cars.add(new Car("Lamborghini", "Diablo", 2001, 175000.0));
        this.cars.add(new Car("Maserati", "Quattroporte", 1999, 90000.0));
        this.cars.add(new Car("Bugatti", "EB110", 2005, 990000.0));
        this.cars.add(new Car("Audi", "R8", 2008, 105000.0));
        this.cars.add(new Car("Volkswagen", "Golf", 1979, 12000.0));
        this.cars.add(new Car("BMW", "850", 1994, 45000.0));
        this.cars.add(new Car("Porsche", "911", 2006, 115000.0));
        this.cars.add(new Car("Mercedes", "SLR", 2004, 345000.0));
        this.cars.add(new Car("Honda", "Type-R", 2005, 25000.0));
        this.cars.add(new Car("Toyota", "Celica", 1993, 20000.0));
        this.cars.add(new Car("Mitsubishi", "Lancer", 2006, 40000.0));
        this.cars.add(new Car("Mazda", "RX-8", 2006, 39000.0));
        this.cars.add(new Car("Hummer", "H1", 2007, 80000.0));
        this.cars.add(new Car("Saleen", "S7", 2008, 680000.0));
        this.cars.add(new Car("Chrysler", "Voyager", 2007, 35000.0));
        this.cars.add(new Car("Chrysler", "Voyager", 2007, 35000.0));
    }

    private void createSales() {
        Random random = new Random(System.currentTimeMillis());
        for (Person buyer : this.persons) {
            for (Person seller : this.persons) {
                if (buyer.equals(seller)) continue;
                Car car = this.cars.get(random.nextInt(this.cars.size()));
                double cost = car.getOriginalValue() * random.nextDouble();
                this.sales.add(new Sale(seller, buyer, car, cost));
            }
        }
    }
}

