/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util.ehcache;

import cn.smarthse.core.framework.common.util.ehcache.EHCacheConfig;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.apache.commons.lang.StringUtils;

public class EHCacheUtil {
    private static CacheManager cacheManager = null;
    private static Cache cache = null;

    static {
        EHCacheUtil.initCacheManager();
        EHCacheUtil.initCache("cache");
    }

    public static CacheManager initCacheManager() {
        try {
            if (cacheManager == null) {
                cacheManager = CacheManager.getInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cacheManager;
    }

    public static CacheManager initCacheManager(String path) {
        try {
            if (cacheManager == null) {
                CacheManager.getInstance();
                cacheManager = CacheManager.create((String)path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cacheManager;
    }

    public static Cache initCache(String cacheName) {
        EHCacheUtil.checkCacheManager();
        if (cacheManager.getCache(cacheName) == null) {
            cacheManager.addCache(cacheName);
        }
        cache = cacheManager.getCache(cacheName);
        return cache;
    }

    public static void put(Object key, Object value) {
        EHCacheUtil.checkCache();
        Element element = new Element(key, value);
        cache.put(element);
    }

    public static Object get(Object key) {
        EHCacheUtil.checkCache();
        Element element = cache.get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public static Object getObjectBeginWith(String key) {
        EHCacheUtil.checkCache();
        Element element = cache.get((Serializable)((Object)key));
        if (element == null) {
            return null;
        }
        Attribute name = cache.getSearchAttribute("name");
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        query.addCriteria(name.ilike(String.valueOf(key) + "?"));
        Results results = query.execute();
        List resultList = results.all();
        for (Result result : resultList) {
            if (results.hasKeys()) {
                System.out.println(result.getKey());
            }
            results.hasValues();
        }
        return element.getObjectValue();
    }

    public static Cache initCache(String cacheName, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) throws Exception {
        try {
            CacheManager singletonManager = CacheManager.create();
            Cache myCache = singletonManager.getCache(cacheName);
            if (myCache != null) {
                CacheConfiguration config = cache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                config.setOverflowToDisk(overflowToDisk);
                config.setEternal(eternal);
                config.setTimeToIdleSeconds(timeToIdleSeconds);
            }
            if (myCache == null) {
                Cache memoryOnlyCache = new Cache(cacheName, maxElementsInMemory, overflowToDisk, eternal, timeToLiveSeconds, timeToIdleSeconds);
                singletonManager.addCache(memoryOnlyCache);
                myCache = singletonManager.getCache(cacheName);
            }
            return myCache;
        }
        catch (Exception e) {
            throw new Exception("init cache " + cacheName + " failed!!!");
        }
    }

    public static Cache initCache(String cacheName, long timeToLiveSeconds) throws Exception {
        return EHCacheUtil.initCache(cacheName, EHCacheConfig.MAXELEMENTSINMEMORY, EHCacheConfig.OVERFLOWTODISK, EHCacheConfig.ETERNAL, timeToLiveSeconds, EHCacheConfig.TIMETOIDLESECONDS);
    }

    public static Cache initMyCache(String cacheName) throws Exception {
        return EHCacheUtil.initCache(cacheName, EHCacheConfig.TIMETOlIVESECONDS);
    }

    public static boolean modifyCache(String cacheName, long timeToLiveSeconds, int maxElementsInMemory) throws Exception {
        try {
            if (StringUtils.isNotBlank((String)cacheName) && timeToLiveSeconds != 0L && maxElementsInMemory != 0) {
                CacheManager myManager = CacheManager.create();
                Cache myCache = myManager.getCache(cacheName);
                CacheConfiguration config = myCache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new Exception("modify cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                myCache = EHCacheUtil.initCache(cacheName);
            }
            myCache.put(new Element((Object)key, value));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value, Integer timeToLiveSeconds) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                EHCacheUtil.initCache(cacheName, timeToLiveSeconds.intValue());
                myCache = myManager.getCache(cacheName);
            }
            myCache.put(new Element((Object)key, value, Boolean.valueOf(EHCacheConfig.ETERNAL), Integer.valueOf(EHCacheConfig.TIMETOIDLESECONDS), timeToLiveSeconds));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static Object getValue(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                myCache = EHCacheUtil.initMyCache(cacheName);
            }
            return myCache.get((Serializable)((Object)key)).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean removeEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            myManager.removeCache(cacheName);
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeAllEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            myManager.removalAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeElment(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            myCache.remove((Serializable)((Object)key));
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeAllElment(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            myCache.removeAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static void shutdown() {
        cacheManager.shutdown();
    }

    public static void removeCache(String cacheName) {
        EHCacheUtil.checkCacheManager();
        cache = cacheManager.getCache(cacheName);
        if (cache != null) {
            cacheManager.removeCache(cacheName);
        }
    }

    public static void remove(String key) {
        EHCacheUtil.checkCache();
        cache.remove((Serializable)((Object)key));
    }

    public static void removeAllCache() {
        EHCacheUtil.checkCacheManager();
        cacheManager.removalAll();
    }

    public static void removeAllKey() {
        EHCacheUtil.checkCache();
        cache.removeAll();
    }

    public static String[] getAllCaches() {
        EHCacheUtil.checkCacheManager();
        return cacheManager.getCacheNames();
    }

    public static List getKeys() {
        EHCacheUtil.checkCache();
        return cache.getKeys();
    }

    private static void checkCacheManager() {
        if (cacheManager == null) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316CacheManager\u503c\uff1aEHCacheUtil.initCacheManager");
        }
    }

    private static void checkCache() {
        if (cache == null) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316Cache\u503c\uff1aEHCacheUtil.initCache(\u53c2\u6570)");
        }
    }

    public static void main(String[] arg) {
        EHCacheUtil.initCacheManager();
        EHCacheUtil.put("A", "AAAAA");
        EHCacheUtil.put("B", "BBBBB");
        EHCacheUtil.put("F", "FFFFF");
        System.out.println(EHCacheUtil.get("F"));
        List keys = EHCacheUtil.getKeys();
        int i = 0;
        while (i < keys.size()) {
            System.out.println(keys.get(i));
            ++i;
        }
        EHCacheUtil.shutdown();
    }
}

