/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import cn.smarthse.core.framework.common.util.StringHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebConfigHandler {
    public static Document loadInit(String filePath) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(filePath));
            document.normalize();
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static boolean updateXML(String filePath, String tagName, String newValue) {
        Document document = WebConfigHandler.loadInit(filePath);
        try {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(tagName);
            if (nodeList != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (node != null) {
                    if (node.getFirstChild() == null) {
                        Text eleText = document.createTextNode(newValue);
                        node.appendChild(eleText);
                    } else {
                        node.getFirstChild().setNodeValue(newValue);
                    }
                    WebConfigHandler.saveXML(document, filePath);
                }
            } else {
                Element newEle = document.createElement(tagName);
                Text eleText = document.createTextNode(newValue);
                newEle.appendChild(eleText);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static boolean updateXMLByObj(String filePath, Object obj) {
        Document document = WebConfigHandler.loadInit(filePath);
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            int fi = 0;
            while (fi < fields.length) {
                String tagName = fields[fi].getName();
                String methodName = "get" + StringHandler.upcaseFirstLetter(tagName);
                Method setMethod = obj.getClass().getDeclaredMethod(methodName, new Class[0]);
                String newValue = (String)setMethod.invoke(obj, new Object[0]);
                if (newValue != null) {
                    Text eleText;
                    Element element = document.getDocumentElement();
                    NodeList nodeList = element.getElementsByTagName(tagName);
                    if (nodeList != null && nodeList.getLength() > 0) {
                        Node node = nodeList.item(0);
                        if (node != null) {
                            if (node.getFirstChild() == null) {
                                eleText = document.createTextNode(newValue);
                                node.appendChild(eleText);
                            } else {
                                node.getFirstChild().setNodeValue(newValue);
                            }
                            WebConfigHandler.saveXML(document, filePath);
                        }
                    } else {
                        Element newEle = document.createElement(tagName);
                        eleText = document.createTextNode(newValue);
                        newEle.appendChild(eleText);
                    }
                }
                ++fi;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static boolean saveXML(Document document, String filePath) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(filePath));
            transformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static Object getConfigInfor(Object obj, String filePath) {
        Document document = WebConfigHandler.loadInit(filePath);
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            int fi = 0;
            while (fi < fields.length) {
                Node node;
                String tagName = fields[fi].getName();
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName(tagName);
                if (nodeList != null && nodeList.getLength() > 0 && (node = nodeList.item(0)) != null && node.getFirstChild() != null) {
                    String tagVal = node.getFirstChild().getNodeValue();
                    String methodName = "set" + StringHandler.upcaseFirstLetter(tagName);
                    Method setMethod = obj.getClass().getDeclaredMethod(methodName, String.class);
                    setMethod.invoke(obj, tagVal);
                }
                ++fi;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }
}

