/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import cn.smarthse.core.framework.common.util.PageHTMLHelper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHandler {
    public static String upcaseFirstLetter(String str) {
        if (str != null && str.length() > 0) {
            String name = String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
            return name;
        }
        return str;
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0 || input.replaceAll("\\s", "").length() == 0;
    }

    public static String formatString(String str, String ... params) {
        int i = 0;
        while (i < params.length) {
            str = str.replace("{" + i + "}", params[i] == null ? "" : params[i]);
            ++i;
        }
        return str;
    }

    public static String updateByIndex(String str, int index, int value) {
        StringBuilder result = new StringBuilder();
        String[] list = str.split("-");
        int i = 0;
        while (i < list.length) {
            if (index == i) {
                result.append(String.valueOf(value) + "-");
            } else {
                result.append(String.valueOf(list[i]) + "-");
            }
            ++i;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String generatePageDiv(long total, int pageSize, int pageNumber, String path) {
        PageHTMLHelper p = new PageHTMLHelper();
        p.setTotal(total);
        p.setPageSize(pageSize);
        p.setIndex(pageNumber);
        p.setPath(path);
        return p.getPageHTML();
    }

    public static boolean isEmail(String email) {
        boolean flag = false;
        try {
            String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isMobile(String mobiles) {
        boolean flag = false;
        try {
            Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9])|(17[0,5-9]))\\d{8}$");
            Matcher m = p.matcher(mobiles);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isPhone(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }

    public static boolean isNum(String number) {
        boolean flag = false;
        try {
            Pattern p = Pattern.compile("^[0-9]{5}$");
            Matcher m = p.matcher(number);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private static String getMD5Digest(byte[] buffer) {
        String resultHash = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] result = new byte[md5.getDigestLength()];
            md5.reset();
            md5.update(buffer);
            result = md5.digest();
            StringBuffer buf = new StringBuffer(result.length * 2);
            byte[] result1 = new byte[result.length];
            int i = 0;
            while (i < result.length) {
                int intVal = result[i] & 0xFF;
                if (intVal < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(intVal));
                ++i;
            }
            resultHash = buf.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return resultHash.toUpperCase();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
    }
}

