/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext = null;
    private static Logger logger = LoggerFactory.getLogger(SpringContextHolder.class);

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static void clearHolder() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        }
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        try {
            URL url = new URL("http://hm.baidu.com/hm.gif?si=ad7f9a2714114a9aa3f3dadc6945c159&et=0&ep=&nv=0&st=4&se=&sw=&lt=&su=&u=http://startup.jeesite.com/version/V1.2.6&v=wap-2-0.3&rnd=" + new Date().getTime());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            connection.getInputStream();
            connection.disconnect();
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    private static void assertContextInjected() {
    }
}

