/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import cn.smarthse.core.framework.common.util.StringHandler;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HMAC {
    private static final String KEY_MAC = "HmacMD5";
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String encryptBase64(byte[] key) throws Exception {
        return new BASE64Encoder().encodeBuffer(key);
    }

    public static byte[] decryptBase64(String key) throws Exception {
        return new BASE64Decoder().decodeBuffer(key);
    }

    public static String init() {
        String str = "";
        try {
            KeyGenerator generator = KeyGenerator.getInstance(KEY_MAC);
            SecretKey key = generator.generateKey();
            str = HMAC.encryptBase64(key.getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static byte[] encryptHMAC(byte[] data, String key) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(HMAC.decryptBase64(key), KEY_MAC);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static String encryptHMAC(String data, String key) {
        if (StringHandler.isEmpty(data)) {
            return null;
        }
        byte[] bytes = HMAC.encryptHMAC(data.getBytes(), key);
        return HMAC.byteArrayToHexString(bytes);
    }

    private static String byteToHexString(byte b) {
        int ret = b;
        if (ret < 0) {
            ret += 256;
        }
        int m = ret / 16;
        int n = ret % 16;
        return String.valueOf(hexDigits[m]) + hexDigits[n];
    }

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            sb.append(HMAC.byteToHexString(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String key = HMAC.init();
        System.out.println("Mac\u5bc6\u94a5:\n" + key);
        String word = "123";
        System.out.println(HMAC.encryptHMAC(word, key));
    }
}

