/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;

public class Exceptions {
    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        Throwable cause = ex.getCause();
        while (cause != null) {
            Class<? extends Exception>[] classArray = causeExceptionClasses;
            int n = causeExceptionClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Exception> causeClass = classArray[n2];
                if (causeClass.isInstance(cause)) {
                    return true;
                }
                ++n2;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static Throwable getThrowable(HttpServletRequest request) {
        Throwable ex = null;
        if (request.getAttribute("exception") != null) {
            ex = (Throwable)request.getAttribute("exception");
        } else if (request.getAttribute("javax.servlet.error.exception") != null) {
            ex = (Throwable)request.getAttribute("javax.servlet.error.exception");
        }
        return ex;
    }
}

