/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CryptUtil {
    private static final String KEY_MD5 = "MD5";
    private static final String KEY_SHA = "SHA";
    public static final String KEY_MAC = "HmacMD5";
    public static final String ALGORITHM = "DES";

    public static byte[] decryptBASE64(String key) throws Exception {
        return new BASE64Decoder().decodeBuffer(key);
    }

    public static String encryptBASE64(byte[] key) throws Exception {
        return new BASE64Encoder().encodeBuffer(key);
    }

    public static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(KEY_MD5);
        md5.update(data);
        return md5.digest();
    }

    public static byte[] encryptSHA(byte[] data) throws Exception {
        MessageDigest sha = MessageDigest.getInstance(KEY_SHA);
        sha.update(data);
        return sha.digest();
    }

    public static String initMacKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_MAC);
        SecretKey secretKey = keyGenerator.generateKey();
        return CryptUtil.encryptBASE64(secretKey.getEncoded());
    }

    public static byte[] encryptHMAC(byte[] data, String key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(CryptUtil.decryptBASE64(key), KEY_MAC);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }

    private static Key toKey(byte[] key) throws Exception {
        SecretKey secretKey = null;
        if (ALGORITHM.equals(ALGORITHM) || ALGORITHM.equals("DESede")) {
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            secretKey = keyFactory.generateSecret(dks);
        } else {
            secretKey = new SecretKeySpec(key, ALGORITHM);
        }
        return secretKey;
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        Key k = CryptUtil.toKey(CryptUtil.decryptBASE64(key));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(byte[] data, String key) throws Exception {
        Key k = CryptUtil.toKey(CryptUtil.decryptBASE64(key));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String initKey() throws Exception {
        return CryptUtil.initKey(null);
    }

    public static String initKey(String seed) throws Exception {
        SecureRandom secureRandom = null;
        secureRandom = seed != null ? new SecureRandom(CryptUtil.decryptBASE64(seed)) : new SecureRandom();
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
        kg.init(secureRandom);
        SecretKey secretKey = kg.generateKey();
        return CryptUtil.encryptBASE64(secretKey.getEncoded());
    }

    public static void main(String[] args) {
        try {
            String s = "\u963f\u4f2f\u624d\u7684\u8986\u76d6";
            String b = CryptUtil.encryptBASE64(s.getBytes("UTF-8"));
            System.out.println("BASE64\u52a0\u5bc6\u540e:" + b);
            byte[] c = CryptUtil.decryptBASE64(b);
            System.out.println("BASE64\u89e3\u5bc6\u540e:" + new String(c, "UTF-8"));
            c = CryptUtil.encryptMD5(s.getBytes());
            System.out.println("MD5   \u52a0\u5bc6\u540e:" + new BigInteger(c).toString(16));
            c = CryptUtil.encryptSHA(s.getBytes());
            System.out.println("SHA   \u52a0\u5bc6\u540e:" + new BigInteger(c).toString(16));
            String key = CryptUtil.initMacKey();
            System.out.println("HMAC\u5bc6\u5319:" + key);
            c = CryptUtil.encryptHMAC(s.getBytes(), key);
            System.out.println("HMAC  \u52a0\u5bc6\u540e:" + new BigInteger(c).toString(16));
            key = CryptUtil.initKey();
            System.out.println("DES\u5bc6\u94a5:\t" + key);
            c = CryptUtil.encrypt(s.getBytes("UTF-8"), key);
            System.out.println("DES   \u52a0\u5bc6\u540e:" + new BigInteger(c).toString(16));
            c = CryptUtil.decrypt(c, key);
            System.out.println("DES   \u89e3\u5bc6\u540e:" + new String(c, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

