/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.util;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieHanler {
    public static final String SESSION_LOGIN_USERNAME = "SESSION_LOGIN_USERNAME";
    public static final String SESSION_LOGIN_PASSWORD = "SESSION_LOGIN_PASSWORD";

    public static void saveCookie(HttpServletRequest request, String username, String password, HttpServletResponse response) {
        String host = request.getServerName();
        Cookie cookie = new Cookie(SESSION_LOGIN_USERNAME, username);
        cookie.setPath("/");
        cookie.setMaxAge(86400);
        response.addCookie(cookie);
        cookie = new Cookie(SESSION_LOGIN_PASSWORD, password);
        cookie.setPath("/");
        cookie.setMaxAge(86400);
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        String host = request.getServerName();
        Cookie cookie = new Cookie(SESSION_LOGIN_USERNAME, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        cookie = new Cookie(SESSION_LOGIN_PASSWORD, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static Map<String, String> getCookieInfo(Cookie[] cks) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (cks != null) {
            Cookie[] cookieArray = cks;
            int n = cks.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if (SESSION_LOGIN_USERNAME.equals(c.getName())) {
                    map.put(SESSION_LOGIN_USERNAME, c.getValue());
                }
                if (SESSION_LOGIN_PASSWORD.equals(c.getName())) {
                    map.put(SESSION_LOGIN_PASSWORD, c.getValue());
                }
                ++n2;
            }
        }
        return map;
    }

    public static String getLastAreaFromCookie(HttpServletRequest request) {
        String cookieName = "lastarea";
        String deFaultValue = "192224";
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return deFaultValue;
        }
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookieName.equals(cookie.getName())) {
                return cookie.getValue();
            }
            ++n2;
        }
        return deFaultValue;
    }

    public static boolean setPriceToCookie(String price, String areaId, HttpServletRequest request, HttpServletResponse response) {
        String cookieName = "productPrice";
        Cookie cookie = new Cookie(cookieName, String.valueOf(areaId) + "-" + price);
        cookie.setPath("/");
        cookie.setMaxAge(86400);
        response.addCookie(cookie);
        return true;
    }

    public static String getPriceFromCookie(HttpServletRequest request) {
        String cookieName = "productPrice";
        String deFaultValue = "192224-0";
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return deFaultValue;
        }
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookieName.equals(cookie.getName())) {
                return cookie.getValue();
            }
            ++n2;
        }
        return deFaultValue;
    }
}

