/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.interprecetor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class FControllerInterceptor
implements HandlerInterceptor {
    private static Logger loggerinfo = LoggerFactory.getLogger(FControllerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String ip = request.getRemoteHost().toString();
        loggerinfo.info("==========[ControllerInterceptor] 1:preHandle...");
        if (!request.getRequestURL().toString().contains("login")) {
            HttpSession httpSession = request.getSession();
            Integer uid = (Integer)httpSession.getAttribute("account_session_uid");
            if (uid == null || uid <= 0) {
                String requestedWith = request.getHeader("x-requested-with");
                if (requestedWith != null && "XMLHttpRequest".equals(requestedWith)) {
                    response.setHeader("session-status", "timeout");
                } else {
                    response.sendRedirect(String.valueOf(request.getContextPath()) + "/account/login.do");
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        loggerinfo.info("==========[ControllerInterceptor] 2:postHandle...");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        loggerinfo.info("==========[ControllerInterceptor] 3:afterCompletion...");
    }
}

