/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.common.generator;

import cn.smarthse.core.framework.common.util.Encodes;
import com.thoughtworks.xstream.core.ReferenceByIdMarshaller;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.UUID;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class IdGen
implements ReferenceByIdMarshaller.IDGenerator,
SessionIdGenerator {
    private static SecureRandom random = new SecureRandom();

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static long randomLong() {
        return Math.abs(random.nextLong());
    }

    public static String randomBase62(int length) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        return Encodes.encodeBase62(randomBytes);
    }

    public Serializable generateId(Session session) {
        return IdGen.uuid();
    }

    public static void main(String[] args) {
        System.out.println(IdGen.uuid());
        System.out.println(IdGen.uuid().length());
        System.out.println(new IdGen().next(null));
        int i = 0;
        while (i < 1000) {
            System.out.println(String.valueOf(IdGen.randomLong()) + "  " + IdGen.randomBase62(5));
            ++i;
        }
    }

    public String next(Object item) {
        return IdGen.uuid();
    }
}

