/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.dao.sceneInspection.impl;

import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentRangeDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionDao;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionMapper;
import cn.smarthse.core.framework.enums.OccupationHealthStageRelation;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspection;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentRange;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentRangeExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionExample;
import cn.smarthse.core.model.vo.InspectionSearchEntity;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import cn.smarthse.core.util.PageAttribute;
import cn.smarthse.core.util.PageUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OccupationHealthInspectionDaoImpl")
public class OccupationHealthInspectionDaoImpl
implements OccupationHealthInspectionDao {
    @Autowired
    private OccupationHealthInspectionMapper inspectionMapper;
    @Resource(name="OccupationHealthInspectionCurrentRangeDaoImpl")
    private OccupationHealthInspectionCurrentRangeDao inspectionRangeDao;

    @Override
    @ReadThroughSingleCache(namespace="OccupationHealthInspection")
    public OccupationHealthInspection selectByPrimaryKey(@ParameterValueKeyProvider Integer primaryKey) {
        return this.inspectionMapper.selectByPrimaryKey(primaryKey);
    }

    @Override
    public int countByExample(OccupationHealthInspectionExample example) {
        return this.inspectionMapper.countByExample(example);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspection")
    public int deleteByPrimaryKey(@ParameterValueKeyProvider Integer primaryKey) {
        OccupationHealthInspection occ = new OccupationHealthInspection();
        occ.setId(primaryKey);
        occ.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(occ);
        return this.inspectionMapper.updateByPrimaryKeySelective(occ);
    }

    @Override
    public int insert(OccupationHealthInspection record) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        record.setCompanyId(LoginUtil.getInstance().getLoginStaffInfo().getCid());
        return this.inspectionMapper.insert(record);
    }

    @Override
    public int insertSelective(OccupationHealthInspection record) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.inspectionMapper.insertSelective(record);
    }

    @Override
    public List<OccupationHealthInspection> selectByExample(OccupationHealthInspectionExample example) {
        return this.inspectionMapper.selectByExample(example);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspection")
    public int updateByPrimaryKeySelective(OccupationHealthInspection record, @ParameterValueKeyProvider Integer primaryKey) {
        if (primaryKey == null || !primaryKey.equals(record.getId())) {
            return 0;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.inspectionMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspection")
    public int updateByPrimaryKey(OccupationHealthInspection record, @ParameterValueKeyProvider Integer primaryKey) {
        if (primaryKey == null || !primaryKey.equals(record.getId())) {
            return 0;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.inspectionMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<OccupationHealthInspection> selectOccupationHealthInspectionListByCompanyId(Integer companyId) {
        if (companyId == null) {
            return null;
        }
        OccupationHealthInspectionExample example = new OccupationHealthInspectionExample();
        OccupationHealthInspectionExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andRecordStateGreaterThan(RecordState.invalid.getValue());
        return this.selectByExample(example);
    }

    @Override
    public List<OccupationHealthInspection> getInspectionUnfinishedList(Integer companyId) {
        OccupationHealthInspectionExample example = new OccupationHealthInspectionExample();
        example.createCriteria().andRecordStateEqualTo(RecordState.valid.getValue()).andCompanyIdEqualTo(companyId);
        example.or().andRecordStateEqualTo(RecordState.draff.getValue()).andCompanyIdEqualTo(companyId);
        example.setOrderByClause("update_date desc");
        return this.inspectionMapper.selectUnfinishedListByExample(example);
    }

    @Override
    public PageInfo<OccupationHealthInspection> getInspectionfinishedList(Integer companyId, InspectionSearchEntity search, Integer pageNum, Integer pageSize) {
        OccupationHealthInspectionExample example = new OccupationHealthInspectionExample();
        OccupationHealthInspectionExample.Criteria criteria = example.createCriteria().andRecordStateEqualTo(RecordState.termination.getValue()).andCompanyIdEqualTo(companyId);
        OccupationHealthInspectionExample.Criteria criteria1 = example.createCriteria().andRecordStateEqualTo(RecordState.immutable.getValue()).andCompanyIdEqualTo(companyId);
        if (search != null) {
            if (StringUtils.isNotEmpty((String)search.getDefaultSearch())) {
                criteria.andInspectionSnLike("%" + search.getDefaultSearch() + "%");
                criteria1.andInspectionSnLike("%" + search.getDefaultSearch() + "%");
            }
            if (search.getInspectionType() != null) {
                criteria.andInspectionTypeEqualTo(search.getInspectionType());
                criteria1.andInspectionTypeEqualTo(search.getInspectionType());
            }
            if (search.getManager() != null) {
                criteria.andInspectionManagerIdEqualTo(search.getManager());
                criteria1.andInspectionManagerIdEqualTo(search.getManager());
            }
            if (search.getRange() != null) {
                OccupationHealthInspectionCurrentRangeExample rangeExample = new OccupationHealthInspectionCurrentRangeExample();
                rangeExample.createCriteria().andRecordStateEqualTo(RecordState.valid.getValue()).andRangeIdEqualTo(search.getRange()).andStageIdEqualTo(OccupationHealthStageRelation.initiate.getStage().getValue());
                List<OccupationHealthInspectionCurrentRange> rangeList = this.inspectionRangeDao.selectByExample(rangeExample);
                ArrayList<Integer> inspectionIdList = new ArrayList<Integer>();
                for (OccupationHealthInspectionCurrentRange range : rangeList) {
                    inspectionIdList.add(range.getInspectionId());
                }
                if (inspectionIdList.size() > 0) {
                    criteria.andIdIn(inspectionIdList);
                    criteria1.andIdIn(inspectionIdList);
                }
            }
        }
        example.or(criteria1);
        example.setOrderByClause("update_date desc");
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspection> inspectionList = this.inspectionMapper.selectfinishedListByExample(example);
        PageInfo page = new PageInfo(inspectionList);
        return page;
    }

    @Override
    public int terminationInspection(List<Integer> inspecitonIds, String terminationReason) {
        int i = 0;
        for (Integer id : inspecitonIds) {
            OccupationHealthInspection occ = new OccupationHealthInspection();
            occ.setId(id);
            occ.setTerminationReason(terminationReason);
            occ.setRecordState(RecordState.termination.getValue());
            i += this.updateByPrimaryKeySelective(occ, id);
        }
        return i;
    }
}

