/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.dao.sceneInspection.impl;

import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentTableDao;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionCurrentTableItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionCurrentTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEmergencyMaterialTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEquipentTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionReformItemTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionWarningSignsTableMapper;
import cn.smarthse.core.framework.enums.InspectionTableSystemType;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEmergencyMaterialTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEquipentTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionWarningSignsTableExample;
import cn.smarthse.core.service.reform.ReformItemService;
import cn.smarthse.core.util.EntityUtil;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OccupationHealthInspectionCurrentTableDaoImpl")
public class OccupationHealthInspectionCurrentTableDaoImpl
implements OccupationHealthInspectionCurrentTableDao {
    @Autowired
    private OccupationHealthInspectionCurrentTableMapper currentTableMapper;
    @Autowired
    private OccupationHealthInspectionCurrentTableItemMapper currentTableItemMapper;
    @Autowired
    OccupationHealthInspectionEmergencyMaterialTableMapper materialMapper;
    @Autowired
    OccupationHealthInspectionEquipentTableMapper equipmentMapper;
    @Autowired
    OccupationHealthInspectionWarningSignsTableMapper warningSingsMapper;
    @Autowired
    OccupationHealthInspectionReformItemTableMapper reformItemMapper;
    @Autowired
    ReformItemService reformItemService;

    @Override
    public int countByExample(OccupationHealthInspectionCurrentTableExample example) {
        return this.currentTableMapper.countByExample(example);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspectionCurrentTable")
    public int deleteByPrimaryKey(@ParameterValueKeyProvider Integer id) {
        OccupationHealthInspectionCurrentTable record = new OccupationHealthInspectionCurrentTable();
        record.setId(id);
        record.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.currentTableMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int insert(OccupationHealthInspectionCurrentTable record) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.currentTableMapper.insert(record);
    }

    @Override
    public int insertSelective(OccupationHealthInspectionCurrentTable record) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.currentTableMapper.insert(record);
    }

    @Override
    public List<OccupationHealthInspectionCurrentTable> selectByInspectionIdAndStageId(Integer inspectionId, Byte stageId, boolean isGetItems) {
        OccupationHealthInspectionCurrentTableExample example = new OccupationHealthInspectionCurrentTableExample();
        example.createCriteria().andInspectionIdEqualTo(inspectionId).andStageIdEqualTo(stageId).andRecordStateGreaterThan(RecordState.invalid.getValue());
        List<OccupationHealthInspectionCurrentTable> list = this.currentTableMapper.selectByExample(example);
        if (isGetItems) {
            for (OccupationHealthInspectionCurrentTable table : list) {
                this.setTableItems(table);
            }
        }
        return list;
    }

    private void setTableItems(OccupationHealthInspectionCurrentTable table) {
        if (table == null) {
            return;
        }
        if (InspectionTableSystemType.custom.getValue().equals(table.getTableNativeCode())) {
            OccupationHealthInspectionCurrentTableItemExample example = new OccupationHealthInspectionCurrentTableItemExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            table.setItems(this.currentTableItemMapper.selectByExample(example));
        } else if (InspectionTableSystemType.emergencyMaterial.getValue().equals(table.getTableNativeCode())) {
            OccupationHealthInspectionEmergencyMaterialTableExample example = new OccupationHealthInspectionEmergencyMaterialTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            table.setMaterials(this.materialMapper.selectByExample(example));
        } else if (InspectionTableSystemType.equipment.getValue().equals(table.getTableNativeCode())) {
            OccupationHealthInspectionEquipentTableExample example = new OccupationHealthInspectionEquipentTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            table.setEquipments(this.equipmentMapper.selectByExample(example));
        } else if (InspectionTableSystemType.warningSigns.getValue().equals(table.getTableNativeCode())) {
            OccupationHealthInspectionWarningSignsTableExample example = new OccupationHealthInspectionWarningSignsTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            table.setWarningSings(this.warningSingsMapper.selectByExample(example));
        } else if (InspectionTableSystemType.reformItem.getValue().equals(table.getTableNativeCode())) {
            OccupationHealthInspectionReformItemTableExample example = new OccupationHealthInspectionReformItemTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            List<OccupationHealthInspectionReformItemTable> list = this.reformItemMapper.selectByExample(example);
            for (OccupationHealthInspectionReformItemTable reformItem : list) {
                if (reformItem.getReformItemId() == null) continue;
                reformItem.setReformItem(this.reformItemService.getItem(reformItem.getReformItemId()));
            }
            table.setReformItem(list);
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="OccupationHealthInspectionCurrentTable")
    public OccupationHealthInspectionCurrentTable selectByPrimaryKey(@ParameterValueKeyProvider Integer id) {
        return this.currentTableMapper.selectByPrimaryKey(id);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspectionCurrentTable")
    public int updateByPrimaryKeySelective(OccupationHealthInspectionCurrentTable record, @ParameterValueKeyProvider Integer primaryKey) {
        if (primaryKey == null || !primaryKey.equals(record.getId())) {
            return 0;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.currentTableMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    @InvalidateSingleCache(namespace="OccupationHealthInspectionCurrentTable")
    public int updateByPrimaryKey(OccupationHealthInspectionCurrentTable record, @ParameterValueKeyProvider Integer primaryKey) {
        if (primaryKey == null || !primaryKey.equals(record.getId())) {
            return 0;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        return this.currentTableMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<OccupationHealthInspectionCurrentTable> selectByExample(OccupationHealthInspectionCurrentTableExample example) {
        return this.currentTableMapper.selectByExample(example);
    }
}

