/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.aop;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.framework.security.shiro.ShiroPrincipal;
import cn.smarthse.core.model.sys.Syslog;
import cn.smarthse.core.service.sys.SysLogService;
import cn.smarthse.core.util.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=2)
public class SYSLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(SYSLogAspect.class);
    @Autowired
    private SysLogService sysLogService;

    public SYSLogAspect() {
        logger.info("\u521d\u59cb\u5316 \u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7 SYSLogAspect");
    }

    @Pointcut(value="execution(* cn.smarthse.core.service..*Service.*(..))")
    public void pointcutExpression() {
    }

    @Before(value="pointcutExpression()")
    public void beforeMethod(JoinPoint joinPoint) {
    }

    @After(value="pointcutExpression()")
    public void afterMethod(JoinPoint joinPoint) {
    }

    @AfterReturning(value="pointcutExpression()", returning="returnValue")
    public void afterRunningMethod(JoinPoint joinPoint, Object returnValue) {
    }

    @AfterThrowing(value="pointcutExpression()", throwing="e")
    public void afterThrowingMethod(JoinPoint joinPoint, Exception e) {
    }

    @Around(value="pointcutExpression()")
    public Object aroundMethod(ProceedingJoinPoint joinPoint) {
        Object object = null;
        try {
            String methodName = joinPoint.getSignature().getName();
            SYSLOG tracedAnnotation = SYSLogAspect.getSYSLOG(joinPoint);
            if (tracedAnnotation != null && Pattern.matches("(batchDelete|delete|del|add|insert|update)[\\S]*", methodName)) {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String ip = HttpUtil.getIpAddr(request);
                ShiroPrincipal user = (ShiroPrincipal)SecurityUtils.getSubject().getPrincipal();
                Integer cid = (Integer)request.getSession().getAttribute("account_companyid");
                Integer uid = (Integer)request.getSession().getAttribute("account_session_uid");
                Syslog log = new Syslog();
                log.setUid(uid);
                log.setOperationip(ip);
                log.setCid(cid);
                log.setCreatetime(new Date());
                log.setContent(this.getMethodBeforeData(joinPoint));
                log.setSavecontent(this.getMethodAfterData(joinPoint));
                log.setRecordid(this.getMethodDataID(joinPoint));
                log.setTablename(this.getMethodModel(joinPoint));
                log.setDescription(tracedAnnotation.desc());
                log.setType(this.getMethodType(methodName));
                this.sysLogService.addSysLog(log);
                object = joinPoint.proceed();
            } else {
                object = Pattern.matches("(get)[\\S]*", methodName) ? joinPoint.proceed() : joinPoint.proceed();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                object = joinPoint.proceed();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        return object;
    }

    private String getMethodModel(ProceedingJoinPoint joinPoint) {
        block6: {
            if (joinPoint.getArgs() != null) break block6;
            return null;
        }
        try {
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            String paramName = null;
            Object[] objectArray = joinPoint.getArgs();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object info = objectArray[n2];
                paramName = info.getClass().getName();
                if (paramName != null && paramName.equals("java.lang.Integer")) {
                    return String.valueOf(targetName) + "." + methodName;
                }
                if (paramName != null && paramName.startsWith("cn.smarthse.core.model")) {
                    return paramName.substring(paramName.lastIndexOf(".") + 1);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getMethodDataID(ProceedingJoinPoint joinPoint) {
        block7: {
            if (joinPoint.getArgs() != null) break block7;
            return null;
        }
        try {
            String paramName = null;
            Object[] objectArray = joinPoint.getArgs();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m;
                Object info = objectArray[n2];
                paramName = info.getClass().getName();
                if (paramName != null && paramName.equals("java.lang.Integer")) {
                    return Integer.valueOf(String.valueOf(info));
                }
                if (paramName != null && paramName.startsWith("cn.smarthse.core.model") && (m = info.getClass().getMethod("getId", new Class[0])) != null) {
                    Object invokeId = m.invoke(joinPoint.getArgs()[0], new Object[0]);
                    if (invokeId == null) {
                        return 0;
                    }
                    return Integer.valueOf(String.valueOf(invokeId));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getMethodAfterData(ProceedingJoinPoint joinPoint) {
        if (joinPoint.getArgs() == null) {
            return null;
        }
        JSONObject msg = new JSONObject();
        String paramName = null;
        Object[] objectArray = joinPoint.getArgs();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object info = objectArray[n2];
            paramName = info.getClass().getName();
            paramName = paramName.substring(paramName.lastIndexOf(".") + 1);
            msg.put(paramName, info);
            ++n2;
        }
        return msg.toJSONString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMethodBeforeData(ProceedingJoinPoint joinPoint) {
        try {
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetclass = joinPoint.getTarget().getClass();
            Object proxy = joinPoint.getThis();
            JSONObject msg = new JSONObject();
            String paramName = null;
            int index = 1;
            Object[] objectArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (true) {
                block10: {
                    Object info;
                    block9: {
                        if (n2 >= n) {
                            return msg.toJSONString();
                        }
                        info = objectArray[n2];
                        paramName = info.getClass().getName();
                        if (paramName == null || !paramName.startsWith("cn.smarthse.core.model")) break block9;
                        String modelName = paramName.substring(paramName.lastIndexOf(".") + 1);
                        String getmethodName = String.format("get%sById", modelName);
                        Method m = info.getClass().getMethod("getId", new Class[0]);
                        if (m != null) {
                            Object invokeId = m.invoke(joinPoint.getArgs()[0], new Object[0]);
                            if (invokeId == null) {
                                return "";
                            }
                            Integer id = Integer.valueOf(String.valueOf(invokeId));
                            try {
                                Method method = targetclass.getMethod(getmethodName, Integer.TYPE);
                                if (method != null) {
                                    msg.put(String.valueOf(modelName) + index++, method.invoke(proxy, id));
                                }
                            }
                            catch (Exception exception) {}
                        }
                        break block10;
                    }
                    msg.put(paramName, info);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getMethodType(String methodName) {
        if (Pattern.matches("batchDelete|delete|del", methodName)) {
            return 2;
        }
        if (Pattern.matches("(insert|add)[\\S]*", methodName)) {
            return 1;
        }
        if (Pattern.matches("(update)[\\S]*", methodName)) {
            return 3;
        }
        if (Pattern.matches("(pdelete|pdel)[\\S]*", methodName)) {
            return 4;
        }
        return 0;
    }

    public static SYSLOG getSYSLOG(ProceedingJoinPoint joinPoint) throws Exception {
        return (SYSLOG)AnnotationUtils.findAnnotation(joinPoint.getTarget().getClass(), SYSLOG.class);
    }
}

