/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.template;

import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.dto.GtReq;
import com.gexin.rp.sdk.template.APNTemplate;
import com.gexin.rp.sdk.template.IncTemplate;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.NotyPopLoadTemplate;
import com.gexin.rp.sdk.template.PopupTransmissionTemplate;
import com.gexin.rp.sdk.template.StartActivityTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;

public class AbstractTemplate
implements ITemplate {
    private String appId;
    private String appkey;
    private GtReq.PushInfo.Builder pushInfo = GtReq.PushInfo.newBuilder().setInvalidAPN(true).setInvalidMPN(true);
    private String duration;
    private GtReq.Transparent transparent = null;
    public static final String notification = "notification";

    public GtReq.Transparent getTransparent() {
        if (this.transparent == null) {
            this.transparent = GtReq.Transparent.newBuilder().setTemplateId(this.getTemplateId()).setId("").setMessageId("").setTaskId("").setAction("pushmessage").addAllActionChain(this.getActionChain()).setPushInfo(this.pushInfo).setAppId(this.appId).setAppKey(this.appkey).addCondition(this.getDurCondition()).build();
        }
        return this.transparent;
    }

    private String getDurCondition() {
        if (this.duration != null && this.duration.length() > 0) {
            return "duration=" + this.duration;
        }
        return "";
    }

    public String getTransmissionContent() {
        return "";
    }

    public String getPushType() {
        return "";
    }

    protected List<GtReq.ActionChain> getActionChain() {
        return null;
    }

    public GtReq.PushInfo getPushInfo() {
        return this.pushInfo.build();
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound) {
        APNPayload apn = new APNPayload();
        APNPayload.DictionaryAlertMsg alertMessage = new APNPayload.DictionaryAlertMsg();
        alertMessage.setActionLocKey(actionLocKey);
        alertMessage.setBody(message);
        apn.setAlertMsg((APNPayload.AlertMsg)alertMessage);
        apn.setBadge(badge);
        apn.setSound(sound);
        this.setAPNInfo((Payload)apn);
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound, String payload, String locKey, String locArgs, String launchImage) throws Exception {
        this.setPushInfo(actionLocKey, badge, message, sound, payload, locKey, locArgs, launchImage, 0);
    }

    @Deprecated
    public void setPushInfo(String actionLocKey, int badge, String message, String sound, String payload, String locKey, String locArgs, String launchImage, Integer contentAvailable) throws Exception {
        APNPayload apn = new APNPayload();
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setActionLocKey(actionLocKey);
        alertMsg.setBody(message);
        alertMsg.setLocKey(locKey);
        alertMsg.addLocArg(locArgs);
        alertMsg.setLaunchImage(launchImage);
        apn.setAlertMsg((APNPayload.AlertMsg)alertMsg);
        apn.setBadge(badge);
        apn.setSound(sound);
        apn.addCustomMsg("payload", (Object)payload);
        apn.setContentAvailable(contentAvailable.intValue());
        this.setAPNInfo((Payload)apn);
    }

    public void setAPNInfo(Payload apn) {
        if (apn == null) {
            return;
        }
        String payload = apn.getPayload();
        if (payload == null || payload.isEmpty()) {
            return;
        }
        try {
            int length = payload.getBytes("UTF-8").length;
            if (length > 2048) {
                throw new RuntimeException("APN payload size overlength (" + length + ">" + 2048 + ")");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.pushInfo.setApnJson(payload).setInvalidAPN(false);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String begin, String end) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long s = sdf.parse(begin).getTime();
        long e = sdf.parse(end).getTime();
        if (s <= 0L || e <= 0L) {
            throw new Exception("DateFormat: yyyy-MM-dd HH:mm:ss");
        }
        if (s > e) {
            throw new Exception("startTime should be smaller than endTime");
        }
        this.duration = s + "-" + e;
    }

    public int getTemplateId() {
        if (this instanceof NotificationTemplate) {
            return 0;
        }
        if (this instanceof LinkTemplate) {
            return 1;
        }
        if (this instanceof NotyPopLoadTemplate) {
            return 2;
        }
        if (this instanceof PopupTransmissionTemplate) {
            return 3;
        }
        if (this instanceof TransmissionTemplate) {
            return 4;
        }
        if (this instanceof APNTemplate) {
            return 5;
        }
        if (this instanceof IncTemplate) {
            return 6;
        }
        if (this instanceof StartActivityTemplate) {
            return 7;
        }
        return -1;
    }
}

