/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.rp.sdk.base.impl.Message;
import com.gexin.rp.sdk.base.impl.TagTarget;
import com.gexin.rp.sdk.base.impl.Target;
import java.util.List;

public class ParamUtils {
    public static Boolean isValidParam(String host, Boolean useSSL) {
        if (host != null && !ParamUtils.isValid(host, useSSL).booleanValue()) {
            throw new IllegalArgumentException(String.format("the arg (%s, %s) is not unified, you can use(https,true) or (http,false), we recommand to use IGtPush(appKey, masterSecret, useSSL)", host, useSSL));
        }
        return true;
    }

    public static Boolean isValid(String host, Boolean useSSL) {
        if (host.toLowerCase().startsWith("http://") && useSSL.booleanValue() || host.toLowerCase().startsWith("https://") && !useSSL.booleanValue()) {
            return false;
        }
        return true;
    }

    public static Boolean checkAppid(Message message, Target target) {
        return ParamUtils.checkAppid(message, target.getAppId());
    }

    public static Boolean checkAppid(Message message, TagTarget tagTarget) {
        return ParamUtils.checkAppid(message, tagTarget.getAppId());
    }

    public static Boolean checkAppid(Message message, List<String> appList) {
        if (appList == null || appList.size() == 0) {
            throw new IllegalArgumentException("appidList can't be empty");
        }
        return ParamUtils.checkAppid(message, appList.get(0));
    }

    private static Boolean checkAppid(Message message, String appid) {
        if (message.getData().getTransparent().getAppId() == null || appid == null) {
            throw new IllegalArgumentException("appid can't be null");
        }
        if (!message.getData().getTransparent().getAppId().equals(appid)) {
            throw new IllegalArgumentException("appid must be uniformity");
        }
        return true;
    }
}

