/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.rp.sdk.base.uitls.StackTraceUtil;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.client.GtHttpClient;
import com.gexin.rp.sdk.http.utils.CallBack;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApiUrlRespectUtils {
    private static final Logger logger = Logger.getLogger(ApiUrlRespectUtils.class.getName());
    private static Map<String, List<String>> appKeyAndHost = new ConcurrentHashMap<String, List<String>>();
    private static Map<String, String> appkeyAndFasterHost = new ConcurrentHashMap<String, String>();
    private static final GtHttpClient client = new GtHttpClient(GTConfig.getHttpConnectionTimeOut(), GTConfig.getHttpSoTimeOut(), 1);
    private static ConcurrentHashMap<String, Set<CallBack>> appKeyCallBack = new ConcurrentHashMap();
    private static boolean isLog = GTConfig.isLogFromGetFastestHost();

    private static void cycleTest() {
        HashMap<String, Long> hostResponseTimeCache = new HashMap<String, Long>();
        for (String appKey : appKeyAndHost.keySet()) {
            long min = Long.MAX_VALUE;
            String fastestHost = null;
            List<String> hosts = appKeyAndHost.get(appKey);
            for (String host : hosts) {
                long responseTime;
                if (hostResponseTimeCache.containsKey(host)) {
                    responseTime = (Long)hostResponseTimeCache.get(host);
                } else {
                    responseTime = ApiUrlRespectUtils.getResponseTime(host);
                    hostResponseTimeCache.put(host, responseTime);
                }
                if (responseTime > min) continue;
                min = responseTime;
                fastestHost = host;
            }
            appkeyAndFasterHost.put(appKey, fastestHost);
            Set<CallBack> callbackList = appKeyCallBack.get(appKey);
            if (callbackList == null) continue;
            for (CallBack callBack : callbackList) {
                callBack.setFasterHost(fastestHost);
            }
        }
    }

    private static long getResponseTime(String host) {
        try {
            long start = System.currentTimeMillis();
            client.executeHead(host);
            long end = System.currentTimeMillis();
            return end - start;
        }
        catch (Throwable e) {
            if (isLog) {
                logger.log(Level.WARNING, "cycle find faster host error: " + StackTraceUtil.getStackTrace((Throwable)e));
            }
            return Long.MAX_VALUE;
        }
    }

    public static String getFastest(String appKey, List<String> hosts, CallBack callBack) {
        if (hosts == null || hosts.size() == 0) {
            throw new IllegalArgumentException("Hosts cann't be null or size must greater than 0");
        }
        ApiUrlRespectUtils.initCycleInspect(appKey, callBack);
        if (appkeyAndFasterHost.containsKey(appKey) && ((Object)hosts).equals(appKeyAndHost.get(appKey))) {
            return appkeyAndFasterHost.get(appKey);
        }
        String fastest = ApiUrlRespectUtils.getFastestRealTime(hosts);
        appKeyAndHost.put(appKey, hosts);
        appkeyAndFasterHost.put(appKey, fastest);
        return fastest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFastestRealTime(List<String> hosts) {
        if (hosts.isEmpty()) {
            throw new RuntimeException("can't get fastest host from empty list");
        }
        if (hosts.size() == 1) {
            return hosts.get(0);
        }
        int length = hosts.size();
        final Object lock = new Object();
        final AtomicInteger counter = new AtomicInteger(length);
        final AtomicBoolean flag = new AtomicBoolean(false);
        final StringBuffer fastestHost = new StringBuffer("");
        Thread[] threads = new Thread[length];
        for (int i = 0; i < length; ++i) {
            final String host = hosts.get(i);
            if (host == null || "".equals(host)) {
                counter.decrementAndGet();
                continue;
            }
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    try {
                        client.executeHead(host);
                        object = lock;
                        synchronized (object) {
                            if (flag.compareAndSet(false, true)) {
                                fastestHost.append(host);
                            }
                            lock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        if (isLog) {
                            logger.log(Level.WARNING, "find faster host error: " + StackTraceUtil.getStackTrace((Throwable)e));
                        }
                    }
                    finally {
                        object = lock;
                        synchronized (object) {
                            if (counter.decrementAndGet() == 0 && !flag.get()) {
                                lock.notifyAll();
                            }
                        }
                    }
                }
            }, "URL-Checker-" + i);
            t.setDaemon(true);
            t.setPriority(10);
            threads[i] = t;
        }
        for (Thread thread : threads) {
            thread.start();
        }
        Object object = lock;
        synchronized (object) {
            if (!flag.get()) {
                try {
                    lock.wait(120000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (fastestHost.length() == 0) {
            fastestHost.append(hosts.get(0));
        }
        if (isLog) {
            logger.log(Level.INFO, "find faster host : " + fastestHost.toString());
        }
        return fastestHost.toString();
    }

    private static synchronized void initCycleInspect(String appKey, CallBack callBack) {
        Set<CallBack> callbackList = appKeyCallBack.get(appKey);
        if (callbackList == null && appKeyCallBack.putIfAbsent(appKey, callbackList = new HashSet<CallBack>()) != null) {
            callbackList = appKeyCallBack.get(appKey);
        }
        callbackList.add(callBack);
    }

    public static void initProxy(GtHttpProxy proxy) {
        client.setProxy(proxy);
    }

    static {
        Thread cycleThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        ApiUrlRespectUtils.cycleTest();
                        continue;
                    }
                    catch (Exception e) {
                        if (!isLog) continue;
                        logger.log(Level.WARNING, "cycleTest Error", e);
                        continue;
                    }
                    finally {
                        try {
                            Thread.sleep(GTConfig.getHttpInspectInterval());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }, "cycleTestThread");
        cycleThread.setDaemon(true);
        cycleThread.start();
    }
}

