/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.client;

import com.gexin.rp.sdk.base.uitls.GZipUtils;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.HttpManager;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class GtHttpClient {
    private int httpSoTimeOut;
    private int httpConnectTimeOut;
    private int maxHttpTryTime = 3;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private GtHttpProxy proxy;
    private Logger logger = Logger.getLogger(HttpManager.class.getName());
    private static boolean isLog = GTConfig.isNeedLog();

    public GtHttpClient(int httpConnectTimeOut, int httpSoTimeOut, int maxHttpTryTime) {
        if (httpConnectTimeOut <= 0) {
            throw new IllegalArgumentException("httpConnectTimeOut must be greater than 0.");
        }
        if (httpSoTimeOut <= 0) {
            throw new IllegalArgumentException("httpSoTimeOut must be greater than 0.");
        }
        if (maxHttpTryTime <= 0) {
            throw new IllegalArgumentException("maxHttpTryTime must be greater than 1.");
        }
        this.httpSoTimeOut = httpSoTimeOut;
        this.httpConnectTimeOut = httpConnectTimeOut;
        this.maxHttpTryTime = maxHttpTryTime;
    }

    public Map<String, Object> executePostJson(String url, Map<String, Object> postJson, boolean postGZip, boolean acceptGZip) throws JsonGenerationException, JsonMappingException, ProtocolException, IOException, Exception {
        byte[] postData = objectMapper.writeValueAsBytes(postJson);
        byte[] responseData = this.executePostBytes(url, postData, postGZip, acceptGZip, (String)postJson.get("action"));
        return (Map)objectMapper.readValue(responseData, Map.class);
    }

    public String executePostString(String url, String postData, boolean postGZip, boolean acceptGZip) throws UnsupportedEncodingException, ProtocolException, IOException, Exception {
        byte[] postDataBytes = postData.getBytes("UTF-8");
        byte[] responseDataBytes = this.executePostBytes(url, postDataBytes, postGZip, acceptGZip, null);
        return new String(responseDataBytes, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] executePostBytes(String url, byte[] postData, boolean postGZip, boolean acceptGZip, String action) throws ProtocolException, IOException, Exception {
        HttpURLConnection connection = this.getHttpURLConnection(url);
        try {
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            if (action != null) {
                connection.setRequestProperty("Gt-Action", action);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.httpConnectTimeOut);
            connection.setReadTimeout(this.httpSoTimeOut);
            if (postGZip) {
                postData = GZipUtils.compress((byte[])postData);
                connection.setRequestProperty("Content-Encoding", "gzip");
                connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
            }
            if (acceptGZip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            if (this.proxy.isAuthProxy()) {
                connection.setRequestProperty("Proxy-Authorization", this.proxy.getBasicAuthString());
            }
            byte[] response = null;
            int tryTime = 0;
            while (tryTime < this.maxHttpTryTime) {
                try {
                    response = GtHttpClient.executePost(connection, postData);
                    break;
                }
                catch (IOException e) {
                    if (++tryTime < this.maxHttpTryTime) continue;
                    throw e;
                }
            }
            if (acceptGZip) {
                byte[] byArray = GZipUtils.decompress(response);
                return byArray;
            }
            byte[] byArray = response;
            return byArray;
        }
        finally {
            connection.disconnect();
        }
    }

    private HttpURLConnection getHttpURLConnection(String urlString) throws MalformedURLException, IOException {
        if (!urlString.toLowerCase().startsWith("http://") && !urlString.toLowerCase().startsWith("https://")) {
            throw new IllegalArgumentException("url(" + urlString + ") must start with \"http://\" or \"https://\"");
        }
        URL url = new URL(urlString);
        HttpURLConnection conn = null;
        if (this.proxy.isProxy()) {
            conn = (HttpURLConnection)url.openConnection(this.proxy.getProxy());
            Authenticator.setDefault(this.proxy.getAuthenticator());
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        String protocal = url.getProtocol();
        if (protocal != null && protocal.equalsIgnoreCase("https")) {
            try {
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                httpsConn.setSSLSocketFactory(HttpManager.getTrustAllSSLContext().getSocketFactory());
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                };
                httpsConn.setHostnameVerifier(hv);
            }
            catch (Exception e) {
                if (isLog) {
                    this.logger.log(Level.WARNING, "init httpmanager error", e);
                }
                throw new RuntimeException("init httpmanager error", e);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] executePost(HttpURLConnection connection, byte[] postData) throws IOException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(connection.getOutputStream());
            bos.write(postData);
            bos.flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        int code = connection.getResponseCode();
        if (code == 200) {
            InputStream inputStream = connection.getInputStream();
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        throw new HttpRetryException("Http Response Error.", code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHead(String url) throws MalformedURLException, IOException, Exception {
        HttpURLConnection connection = this.getHttpURLConnection(url);
        try {
            connection.setRequestMethod("HEAD");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.httpConnectTimeOut);
            connection.setReadTimeout(this.httpSoTimeOut);
            int tryTime = 0;
            while (tryTime < this.maxHttpTryTime) {
                int code;
                block8: {
                    try {
                        connection.connect();
                        code = connection.getResponseCode();
                        if (code != 200) break block8;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        if (++tryTime < this.maxHttpTryTime) continue;
                        throw e;
                    }
                }
                throw new HttpRetryException("Response Code Error", code, url);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }

    public void setProxy(GtHttpProxy proxy) {
        this.proxy = proxy;
    }
}

