/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.rp.sdk.base.IAliasResult;
import com.gexin.rp.sdk.base.IBatch;
import com.gexin.rp.sdk.base.IGtAPN;
import com.gexin.rp.sdk.base.IGtAlias;
import com.gexin.rp.sdk.base.IIGtPush;
import com.gexin.rp.sdk.base.IIGtQuery;
import com.gexin.rp.sdk.base.IListProvider;
import com.gexin.rp.sdk.base.IPushEventListener;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.Message;
import com.gexin.rp.sdk.base.impl.PushResult;
import com.gexin.rp.sdk.base.impl.QueryResult;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.TagTarget;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.base.uitls.Base64Util;
import com.gexin.rp.sdk.base.uitls.LangUtil;
import com.gexin.rp.sdk.base.uitls.SignUtil;
import com.gexin.rp.sdk.exceptions.PushAppException;
import com.gexin.rp.sdk.http.BatchImpl;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.HttpManager;
import com.gexin.rp.sdk.http.IGtHttpProxy;
import com.gexin.rp.sdk.http.utils.AliasResultUtil;
import com.gexin.rp.sdk.http.utils.ApiUrlRespectUtils;
import com.gexin.rp.sdk.http.utils.CallBack;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GtPush
implements IIGtPush,
IIGtQuery,
IGtAPN,
IGtAlias {
    private Logger logger = Logger.getLogger(GtPush.class.getName());
    private String appKey;
    private String host;
    private String masterSecret;
    private Boolean useSSL;
    private static HttpManager httpManager = new HttpManager();
    private static ConcurrentHashMap<String, List<String>> appkeyUrlList = new ConcurrentHashMap();
    private List<String> domainUrlList;
    private CallBack callBack = new CallBack(){

        @Override
        public void setFasterHost(String host) {
            GtPush.this.host = host;
            if (isLog) {
                GtPush.this.logger.log(Level.INFO, "switch faster host : " + host);
            }
        }
    };
    private static boolean isLog = GTConfig.isNeedLog();

    public GtPush(String domainUrl, String appKey, String masterSecret, Boolean useSSL) {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
        if (useSSL == null && domainUrl != null && domainUrl.toLowerCase().startsWith("https")) {
            useSSL = true;
        }
        GtHttpProxy proxy = new GtHttpProxy(new IGtHttpProxy());
        httpManager.setProxy(proxy);
        ApiUrlRespectUtils.initProxy(proxy);
        this.useSSL = useSSL == null ? false : useSSL;
        if (domainUrl == null || domainUrl.trim().length() <= 0) {
            this.domainUrlList = GTConfig.getDefaultDomainUrl(this.useSSL);
        } else {
            this.domainUrlList = new ArrayList<String>();
            this.domainUrlList.add(domainUrl);
        }
        if (Boolean.getBoolean("needOSAsigned")) {
            this.initOSDomain(this.domainUrlList);
        } else {
            this.initOSDomain(null);
        }
    }

    private String initOSDomain(List<String> hosts) {
        if (hosts == null || hosts.size() == 0) {
            hosts = appkeyUrlList.get(this.appKey);
            if (hosts == null || hosts.size() == 0) {
                hosts = this.getOSPushDomainUrlList(this.domainUrlList, this.appKey);
                appkeyUrlList.putIfAbsent(this.appKey, hosts);
            }
        } else {
            appkeyUrlList.put(this.appKey, hosts);
        }
        this.host = ApiUrlRespectUtils.getFastest(this.appKey, hosts, this.callBack);
        return this.host;
    }

    private List<String> getOSPushDomainUrlList(List<String> hosts, String appKey) {
        List urlList = null;
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "getOSPushDomailUrlListAction");
        postData.put("appkey", appKey);
        Exception ex = null;
        for (String host : hosts) {
            try {
                Map<String, Object> response = httpManager.httpPostJSON(host, postData, false);
                urlList = (List)response.get("osList");
                if (urlList == null || urlList.size() <= 0) continue;
                break;
            }
            catch (Exception e) {
                if (isLog) {
                    this.logger.log(Level.WARNING, "get hosts error: " + host, e);
                }
                ex = e;
            }
        }
        if (urlList == null || urlList.size() <= 0) {
            throw new RuntimeException("Can not get hosts from " + hosts, ex);
        }
        return urlList;
    }

    protected Map<String, Object> httpPostJSON(String url, Map<String, Object> data) {
        return this.httpPostJSON(url, data, false);
    }

    protected Map<String, Object> httpPostJSON(Map<String, Object> data, boolean gzip) {
        return this.httpPostJSON(this.host, data, gzip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Object> httpPostJSON(String url, Map<String, Object> data, boolean gzip) {
        data.put("version", GTConfig.getSDKVersion());
        Map<String, Object> response = httpManager.httpPostJSON(url, data, gzip);
        if (response == null) return response;
        if ("sign_error".equals(response.get("result"))) {
            try {
                if (!this.connect()) return response;
                return httpManager.httpPostJSON(url, data, gzip);
            }
            catch (IOException e) {
                throw new RuntimeException("\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
        if (!"domain_error".equals(response.get("result"))) return response;
        url = this.initOSDomain((List)response.get("osList"));
        return httpManager.httpPostJSON(url, data, gzip);
    }

    public boolean connect() throws IOException {
        long timeStamp = System.currentTimeMillis();
        String sign = SignUtil.getSign((String)this.appKey, (String)this.masterSecret, (long)timeStamp);
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "connect");
        postData.put("appkey", this.appKey);
        postData.put("timeStamp", timeStamp);
        postData.put("sign", sign);
        Map<String, Object> response = httpManager.httpPostJSON(this.host, postData, false);
        String result = LangUtil.parseString((Object)response.get("result"));
        return result != null && "success".equals(result);
    }

    public void close() throws IOException {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "close");
        postData.put("appkey", this.appKey);
        httpManager.httpPostJSON(this.host, postData, false);
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target) {
        return this.pushMessageToSingle(message, target, null);
    }

    public IPushResult pushMessageToSingleByTag(SingleMessage message, TagTarget target) {
        return this.pushMessageToSingleByTag(message, target, null);
    }

    public IPushResult pushMessageToSingleByTag(SingleMessage message, TagTarget target, String requestId) {
        if (requestId == null || "".equals(requestId.trim())) {
            requestId = UUID.randomUUID().toString();
        }
        PushResult pushResult = new PushResult();
        Map<String, Object> postData = this.getSingleMessagePostData(message, target, requestId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target, String requestId) {
        if (requestId == null || "".equals(requestId.trim())) {
            requestId = UUID.randomUUID().toString();
        }
        PushResult pushResult = new PushResult();
        Map<String, Object> postData = this.getSingleMessagePostData(message, target, requestId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    Map<String, Object> getSingleMessagePostData(SingleMessage message, TagTarget target, String requestId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "pushMessageToSingleByTagAction");
        postData.put("appkey", this.appKey);
        if (requestId != null) {
            postData.put("requestId", requestId);
        }
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("appId", target.getAppId());
        postData.put("clientId", target.getClientId());
        postData.put("tag", target.getTag());
        postData.put("type", 2);
        postData.put("pushType", message.getData().getPushType());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        return postData;
    }

    Map<String, Object> getSingleMessagePostData(SingleMessage message, Target target, String requestId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "pushMessageToSingleAction");
        postData.put("appkey", this.appKey);
        if (requestId != null) {
            postData.put("requestId", requestId);
        }
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("appId", target.getAppId());
        postData.put("clientId", target.getClientId());
        postData.put("alias", target.getAlias());
        postData.put("type", 2);
        postData.put("pushType", message.getData().getPushType());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        return postData;
    }

    public void pushMessageToList(ListMessage message, IListProvider listProvider, IPushEventListener listener) {
        List targetList;
        String contentId = this.getContentId(message);
        int page = 0;
        while ((targetList = listProvider.getClientList(page)) != null) {
            IPushResult pushResult = this.pushMessageToList(contentId, targetList);
            listener.process(pushResult);
            ++page;
        }
    }

    public String getContentId(ListMessage message) {
        return this.getListAppContentId((Message)message, null);
    }

    public String getContentId(ListMessage message, String taskGroupName) {
        return this.getListAppContentId((Message)message, taskGroupName);
    }

    public boolean cancelContentId(String contentId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        boolean success = false;
        postData.put("action", "cancleContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        if ("ok".equals(LangUtil.parseString((Object)response.get("result")))) {
            success = true;
        }
        return success;
    }

    private IPushResult blackCidList(String appId, List<String> cidList, int optType) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        int limit = GTConfig.getMaxLenOfBlackCidList();
        if (limit < cidList.size()) {
            throw new IllegalArgumentException("cidList size:" + cidList.size() + " beyond the limit:" + limit);
        }
        postData.put("action", "blackCidAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("cidList", cidList);
        postData.put("optType", optType);
        Map<String, Object> response = this.httpPostJSON(this.host, postData, true);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult addCidListToBlk(String appId, List<String> cidList) {
        return this.blackCidList(appId, cidList, 1);
    }

    public IPushResult restoreCidListFromBlk(String appId, List<String> cidList) {
        return this.blackCidList(appId, cidList, 2);
    }

    public IPushResult pushMessageToListByTag(String contentId, List<TagTarget> targetList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "pushMessageToListByTagAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        boolean needDetails = GTConfig.isPushListNeedDetails();
        postData.put("needDetails", needDetails);
        boolean async = GTConfig.isPushListAsync();
        postData.put("async", async);
        boolean needAliasDetails = GTConfig.isPushListNeedAliasDetails();
        postData.put("needAliasDetails", needAliasDetails);
        int limit = async && !needDetails ? GTConfig.getAsyncListLimit() : GTConfig.getSyncListLimit();
        if (targetList.size() > limit) {
            throw new IllegalArgumentException("target size:" + targetList.size() + " beyond the limit:" + limit);
        }
        ArrayList clientIdList = new ArrayList();
        ArrayList aliasList = new ArrayList();
        String appId = null;
        for (TagTarget target : targetList) {
            String targetCid = target.getClientId();
            String targetAlias = target.getAlias();
            if (targetCid != null && !"".equals(targetCid.trim())) {
                HashMap<String, String> cidtag = new HashMap<String, String>();
                cidtag.put(targetCid, target.getTag());
                clientIdList.add(cidtag);
            } else if (targetAlias != null && !"".equals(targetAlias.trim())) {
                HashMap<String, String> aliastag = new HashMap<String, String>();
                aliastag.put(targetAlias, target.getTag());
                aliasList.add(aliastag);
            }
            if (appId != null && !"".equals(appId.trim())) continue;
            appId = target.getAppId();
        }
        postData.put("appId", appId);
        postData.put("clientIdList", clientIdList);
        postData.put("aliasList", aliasList);
        postData.put("type", 2);
        Map<String, Object> response = this.httpPostJSON(this.host, postData, true);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushMessageToList(String contentId, List<Target> targetList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "pushMessageToListAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        boolean needDetails = GTConfig.isPushListNeedDetails();
        postData.put("needDetails", needDetails);
        boolean async = GTConfig.isPushListAsync();
        postData.put("async", async);
        boolean needAliasDetails = GTConfig.isPushListNeedAliasDetails();
        postData.put("needAliasDetails", needAliasDetails);
        int limit = async && !needDetails ? GTConfig.getAsyncListLimit() : GTConfig.getSyncListLimit();
        if (targetList.size() > limit) {
            throw new IllegalArgumentException("target size:" + targetList.size() + " beyond the limit:" + limit);
        }
        ArrayList<String> clientIdList = new ArrayList<String>();
        ArrayList<String> aliasList = new ArrayList<String>();
        String appId = null;
        for (Target target : targetList) {
            String targetCid = target.getClientId();
            String targetAlias = target.getAlias();
            if (targetCid != null && !"".equals(targetCid.trim())) {
                clientIdList.add(targetCid);
            } else if (targetAlias != null && !"".equals(targetAlias.trim())) {
                aliasList.add(targetAlias);
            }
            if (appId != null && !"".equals(appId.trim())) continue;
            appId = target.getAppId();
        }
        postData.put("appId", appId);
        postData.put("clientIdList", clientIdList);
        postData.put("aliasList", aliasList);
        postData.put("type", 2);
        Map<String, Object> response = this.httpPostJSON(this.host, postData, true);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushMessageToApp(AppMessage message) throws PushAppException {
        String contentId = this.getListAppContentId((Message)message, null);
        return this.pushMessageToApp(contentId);
    }

    public IPushResult pushMessageToApp(AppMessage message, String taskGroupName) throws PushAppException {
        String contentId = this.getListAppContentId((Message)message, taskGroupName);
        return this.pushMessageToApp(contentId);
    }

    public boolean stop(String contentId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "stopTaskAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        return "ok".equals(response.get("result"));
    }

    public IQueryResult getClientIdStatus(String appId, String clientId) {
        QueryResult result = new QueryResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "getClientIdStatusAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        result.setResponse(response);
        return result;
    }

    public IQueryResult setClientTag(String appId, String clientId, List<String> tags) {
        QueryResult result = new QueryResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "setTagAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        postData.put("tagList", tags);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        result.setResponse(response);
        return result;
    }

    private IQueryResult setBadge(String badge, String appid, List<String> deviceTokenList, List<String> cidList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "setBadgeAction");
        postData.put("appkey", this.appKey);
        postData.put("badge", badge);
        postData.put("appid", appid);
        postData.put("deviceToken", deviceTokenList);
        postData.put("cid", cidList);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        QueryResult result = new QueryResult();
        result.setResponse(response);
        return result;
    }

    public IQueryResult setBadgeForCID(String badge, String appid, List<String> cidList) {
        return this.setBadge(badge, appid, new ArrayList<String>(), cidList);
    }

    public IQueryResult setBadgeForDeviceToken(String badge, String appid, List<String> deviceTokenList) {
        return this.setBadge(badge, appid, deviceTokenList, new ArrayList<String>());
    }

    private IPushResult pushMessageToApp(String contentId) throws PushAppException {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        try {
            postData.put("action", "pushMessageToAppAction");
            postData.put("appkey", this.appKey);
            postData.put("contentId", contentId);
            postData.put("type", 2);
            Map<String, Object> response = this.httpPostJSON(this.host, postData);
            pushResult.setResponse(response);
            return pushResult;
        }
        catch (Exception e) {
            throw new PushAppException(contentId, (Throwable)e);
        }
    }

    private String getListAppContentId(Message message, String taskGroupName) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        Map<String, Object> response = null;
        if (taskGroupName != null) {
            postData.put("taskGroupName", taskGroupName);
        }
        postData.put("action", "getContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("pushType", message.getData().getPushType());
        postData.put("type", 2);
        if (message instanceof ListMessage) {
            postData.put("contentType", 1);
        } else if (message instanceof AppMessage) {
            postData.put("contentType", 2);
            AppMessage appMessage = (AppMessage)message;
            postData.put("appIdList", appMessage.getAppIdList());
            List phoneTypeList = null;
            List provinceList = null;
            List tagList = null;
            ArrayList personaTags = new ArrayList();
            if (appMessage.getConditions() == null) {
                phoneTypeList = appMessage.getPhoneTypeList();
                provinceList = appMessage.getProvinceList();
                tagList = appMessage.getTagList();
                postData.put("phoneTypeList", phoneTypeList);
                postData.put("provinceList", provinceList);
                postData.put("tagList", tagList);
            } else {
                List conditions = appMessage.getConditions().getCondition();
                postData.put("conditions", conditions);
            }
            postData.put("speed", appMessage.getSpeed());
        }
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        response = this.httpPostJSON(this.host, postData);
        String result = LangUtil.parseString((Object)response.get("result"));
        String contentId = LangUtil.parseString((Object)response.get("contentId"));
        if ("ok".equals(result) && contentId != null) {
            return contentId;
        }
        throw new RuntimeException("host:[" + this.host + "]" + "\u83b7\u53d6contentId\u5931\u8d25:" + result);
    }

    public IBatch getBatch() {
        return new BatchImpl(this.appKey, this);
    }

    public IPushResult pushAPNMessageToSingle(String appId, String deviceToken, SingleMessage message) {
        PushResult pushResult = new PushResult();
        if (deviceToken == null || deviceToken.length() != 64) {
            throw new IllegalArgumentException("deviceToken[" + deviceToken + "] length must be 64");
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "apnPushToSingleAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("DT", deviceToken);
        postData.put("PI", Base64Util.getBASE64((byte[])message.getData().getPushInfo().toByteArray()));
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushAPNMessageToList(String appId, String contentId, List<String> deviceTokenList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        for (String deviceToken : deviceTokenList) {
            if (deviceToken != null && deviceToken.length() == 64) continue;
            throw new IllegalArgumentException("deviceToken[" + deviceToken + "] length must be 64");
        }
        postData.put("action", "apnPushToListAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("contentId", contentId);
        postData.put("DTL", deviceTokenList);
        postData.put("needDetails", GTConfig.isPushListNeedDetails());
        postData.put("async", GTConfig.isPushListAsync());
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public String getAPNContentId(String appId, ListMessage message) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        Map<String, Object> response = null;
        postData.put("action", "apnGetContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("PI", Base64Util.getBASE64((byte[])message.getData().getPushInfo().toByteArray()));
        response = this.httpPostJSON(this.host, postData);
        String result = LangUtil.parseString((Object)response.get("result"));
        String contentId = LangUtil.parseString((Object)response.get("contentId"));
        if ("ok".equals(result) && contentId != null) {
            return contentId;
        }
        throw new RuntimeException("host:[" + this.host + "]" + "\u83b7\u53d6contentId\u5931\u8d25:" + result);
    }

    public IAliasResult bindAlias(String appId, String alias, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_bind");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        postData.put("cid", clientId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult bindAlias(String appId, List<Target> targetList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        ArrayList aliaslist = new ArrayList();
        for (Target target : targetList) {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("cid", target.getClientId());
            user.put("alias", target.getAlias());
            aliaslist.add(user);
        }
        postData.put("action", "alias_bind_list");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("aliaslist", aliaslist);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult queryClientId(String appId, String alias) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_query");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        response.put("alias", alias);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult queryAlias(String appId, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_query");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("cid", clientId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult unBindAlias(String appId, String alias, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_unbind");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        if (clientId != null && clientId.trim().length() > 0) {
            postData.put("cid", clientId);
        }
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult unBindAliasAll(String appId, String alias) {
        return this.unBindAlias(appId, alias, null);
    }

    public IPushResult getPushResult(String taskId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "getPushMsgResult");
        postData.put("appkey", this.appKey);
        postData.put("taskId", taskId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult getPushResultByGroupName(String appId, String groupName) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult queryResult = new QueryResult();
        postData.put("action", "getPushResultByGroupName");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("groupName", groupName);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        queryResult.setResponse(response);
        return queryResult;
    }

    public IQueryResult getLast24HoursOnlineUserStatistics(String appId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult queryResult = new QueryResult();
        postData.put("action", "getLast24HoursOnlineUser");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        queryResult.setResponse(response);
        return queryResult;
    }

    public IPushResult getUserTags(String appId, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "getUserTags");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult queryAppPushDataByDate(String appId, String date) {
        if (!LangUtil.validateDate((String)date)) {
            throw new IllegalArgumentException("DateError|" + date);
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryAppPushData");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("date", date);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult queryAppUserDataByDate(String appId, String date) {
        if (!LangUtil.validateDate((String)date)) {
            throw new IllegalArgumentException("DateError|" + date);
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryAppUserData");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("date", date);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult getPersonaTags(String appId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "getPersonaTags");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult queryUserCount(String appId, AppConditions conditions) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryUserCount");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        if (conditions != null) {
            postData.put("conditions", conditions.getCondition());
        }
        Map<String, Object> response = this.httpPostJSON(this.host, postData);
        pushResult.setResponse(response);
        return pushResult;
    }
}

