/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.apns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class Payload {
    private static final String APS = "aps";
    private Map<String, Object> params;
    private String alert;
    private Integer badge;
    private String sound = "";
    private String alertBody;
    private String alertActionLocKey;
    private String alertLocKey;
    private String[] alertLocArgs;
    private String alertLaunchImage;
    private Integer contentAvailable;

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void addParam(String key, Object obj) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if (APS.equalsIgnoreCase(key)) {
            throw new IllegalArgumentException("the key can't be aps");
        }
        this.params.put(key, obj);
    }

    public String getAlert() {
        return this.alert;
    }

    public void setAlert(String alert) {
        this.alert = alert;
    }

    public Integer getBadge() {
        return this.badge;
    }

    public void setBadge(Integer badge) {
        this.badge = badge;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public Integer getContentAvailable() {
        return this.contentAvailable;
    }

    public void setContentAvailable(Integer contentAvailable) {
        this.contentAvailable = contentAvailable;
    }

    public String toString() {
        HashMap<String, Object> object = new HashMap<String, Object>();
        HashMap<String, Object> apsObj = new HashMap<String, Object>();
        if (this.getAlert() != null) {
            apsObj.put("alert", this.getAlert());
        } else if (this.getAlertBody() != null || this.getAlertLocKey() != null) {
            HashMap<String, Object> alertObj = new HashMap<String, Object>();
            this.putIntoJson("body", this.getAlertBody(), alertObj);
            this.putIntoJson("action-loc-key", this.getAlertActionLocKey(), alertObj);
            this.putIntoJson("loc-key", this.getAlertLocKey(), alertObj);
            this.putIntoJson("launch-image", this.getAlertLaunchImage(), alertObj);
            if (this.getAlertLocArgs() != null) {
                ArrayList<String> array = new ArrayList<String>();
                for (String str : this.getAlertLocArgs()) {
                    array.add(str);
                }
                alertObj.put("loc-args", array);
            }
            apsObj.put("alert", alertObj);
        }
        if (this.getBadge() != null) {
            apsObj.put("badge", this.getBadge());
        }
        if (!"com.gexin.ios.silence".equals(this.getSound())) {
            this.putIntoJson("sound", this.getSound(), apsObj);
        }
        if (this.getContentAvailable() != null && this.getContentAvailable() == 1) {
            apsObj.put("content-available", (int)this.getContentAvailable());
        }
        object.put(APS, apsObj);
        if (this.getParams() != null) {
            for (Map.Entry<String, Object> e : this.getParams().entrySet()) {
                object.put(e.getKey(), e.getValue());
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("build apn payload json error", e);
        }
    }

    private void putIntoJson(String key, String value, Map<String, Object> obj) {
        if (value != null) {
            obj.put(key, value);
        }
    }

    public String getAlertBody() {
        return this.alertBody;
    }

    public void setAlertBody(String alertBody) {
        this.alertBody = alertBody;
    }

    public String getAlertActionLocKey() {
        return this.alertActionLocKey;
    }

    public void setAlertActionLocKey(String alertActionLocKey) {
        this.alertActionLocKey = alertActionLocKey;
    }

    public String getAlertLocKey() {
        return this.alertLocKey;
    }

    public void setAlertLocKey(String alertLocKey) {
        this.alertLocKey = alertLocKey;
    }

    public String getAlertLaunchImage() {
        return this.alertLaunchImage;
    }

    public void setAlertLaunchImage(String alertLaunchImage) {
        this.alertLaunchImage = alertLaunchImage;
    }

    public String[] getAlertLocArgs() {
        return this.alertLocArgs;
    }

    public void setAlertLocArgs(String[] alertLocArgs) {
        this.alertLocArgs = alertLocArgs;
    }
}

