/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.cache.service;

import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisCacheService<E> {
    private RedisTemplate<String, E> redisTemplate;
    private RedisTemplate<String, String> strRedisTemplate;
    private Lock lock = new ReentrantLock();

    public void put(String key, E obj) {
        ValueOperations valueOper = this.redisTemplate.opsForValue();
        valueOper.set((Object)key, obj);
    }

    public E get(String key) {
        ValueOperations valueOper = this.redisTemplate.opsForValue();
        return (E)valueOper.get((Object)key);
    }

    public boolean contains(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    private RedisSerializer<String> getRedisSerializer() {
        return this.strRedisTemplate.getStringSerializer();
    }

    public Long removeFuzzy(String key) {
        final String finalKey = key + "*";
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                long result = 0L;
                Set keys = connection.keys(finalKey.getBytes());
                for (byte[] keySet : keys) {
                    result += connection.del((byte[][])new byte[][]{keySet}).longValue();
                }
                return result;
            }
        });
    }

    public void convertAndSend(String channel, String message) {
        this.redisTemplate.convertAndSend(channel, (Object)message);
    }

    public RedisTemplate<String, E> getRedisTemplate() {
        return this.redisTemplate;
    }

    public RedisTemplate<String, String> getStrRedisTemplate() {
        return this.strRedisTemplate;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setRedisTemplate(RedisTemplate<String, E> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setStrRedisTemplate(RedisTemplate<String, String> strRedisTemplate) {
        this.strRedisTemplate = strRedisTemplate;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisCacheService)) {
            return false;
        }
        RedisCacheService other = (RedisCacheService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, E> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, E> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        RedisTemplate<String, String> this$strRedisTemplate = this.getStrRedisTemplate();
        RedisTemplate<String, String> other$strRedisTemplate = other.getStrRedisTemplate();
        if (this$strRedisTemplate == null ? other$strRedisTemplate != null : !this$strRedisTemplate.equals(other$strRedisTemplate)) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisCacheService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, E> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        RedisTemplate<String, String> $strRedisTemplate = this.getStrRedisTemplate();
        result = result * 59 + ($strRedisTemplate == null ? 43 : $strRedisTemplate.hashCode());
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }

    public String toString() {
        return "RedisCacheService(redisTemplate=" + this.getRedisTemplate() + ", strRedisTemplate=" + this.getStrRedisTemplate() + ", lock=" + this.getLock() + ")";
    }
}

