/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.handler;

import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.api.result.ResultTemplate;
import com.fengwenyi.apistarter.enums.ReturnCode;
import com.fengwenyi.apistarter.exception.ApiException;
import com.fengwenyi.apistarter.exception.ParamException;
import com.fengwenyi.javalib.util.MdcUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResultTemplate<Void> missingServletRequestParameterExceptionHandler(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.error("MissingServletRequestParameterException, uri:{}", (Object)request.getRequestURI());
        log.error("msg={}", (Object)e.getParameterName());
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)ReturnCode.PARAM_MISS, (String)("\u53c2\u6570\u7f3a\u5931\u5f02\u5e38: [" + e.getParameterName() + "]"));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResultTemplate<Void> handleParamCheckException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("MethodArgumentNotValidException, uri:{}", (Object)request.getRequestURI());
        BindingResult bindingResult = e.getBindingResult();
        StringJoiner errMsgJoiner = new StringJoiner(",", "[", "]");
        if (bindingResult.hasErrors()) {
            List allErrors = bindingResult.getAllErrors();
            for (ObjectError objectError : allErrors) {
                String msg = objectError.getDefaultMessage();
                if (!StringUtils.hasText((String)msg)) continue;
                errMsgJoiner.add(msg);
            }
        }
        log.error("msg={}", (Object)errMsgJoiner);
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)ReturnCode.PARAM_VALIDATED, (String)("\u53c2\u6570\u68c0\u9a8c\u5931\u8d25: " + errMsgJoiner));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResultTemplate<Void> constraintViolationExceptionHandler(HttpServletRequest request, ConstraintViolationException e) {
        log.error("ConstraintViolationException, uri:{}", (Object)request.getRequestURI());
        Set constraintViolations = e.getConstraintViolations();
        StringJoiner errMsgJoiner = new StringJoiner(",", "[", "]");
        for (ConstraintViolation constraintViolation : constraintViolations) {
            String errMsg = constraintViolation.getMessageTemplate();
            if (!StringUtils.hasText((String)errMsg)) continue;
            errMsgJoiner.add(errMsg);
        }
        log.error("msg={}", (Object)errMsgJoiner);
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)ReturnCode.PARAM_VALIDATED, (String)("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: " + errMsgJoiner));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ParamException.class})
    public ResultTemplate<Void> paramExceptionHandler(HttpServletRequest request, ParamException e) {
        log.error("ParamException, uri:{}", (Object)request.getRequestURI());
        log.error("msg={}", (Object)e.getMessage());
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)ReturnCode.PARAM_EXCEPTION, (String)("\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage()));
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ApiException.class})
    public ResultTemplate<Void> apiExceptionHandler(HttpServletRequest request, ApiException e) {
        log.error("ApiException, uri:{}", (Object)request.getRequestURI());
        IReturnCode returnCode = e.getReturnCode();
        String message = e.getMessage();
        if (Objects.isNull(returnCode)) {
            log.error("msg={}", (Object)message);
            return ResultTemplate.fail((String)message);
        }
        if (StringUtils.hasText((String)message)) {
            log.error("errCode={}, msg={}", (Object)returnCode.getErrCode(), (Object)message);
            return ResultTemplate.fail((IReturnCode)returnCode, (String)message);
        }
        log.error("errCode={}, msg={}", (Object)returnCode.getErrCode(), (Object)returnCode.getMsg());
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)returnCode);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResultTemplate<Void> exceptionHandler(HttpServletRequest request, Exception e) {
        log.error("Exception, uri:{}", (Object)request.getRequestURI(), (Object)e);
        MdcUtils.clear();
        return ResultTemplate.fail((IReturnCode)ReturnCode.ERROR);
    }
}

