/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.api.result;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.api.result.ResponseHeader;
import com.fengwenyi.javalib.util.StringUtils;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseTemplate<T>
implements Serializable {
    private static final long serialVersionUID = -4206473602305400988L;
    private static final IReturnCode SUCCESS = IReturnCode.Default.SUCCESS;
    private static final IReturnCode ERROR = IReturnCode.Default.ERROR;
    private Integer code;
    private String message;
    private Boolean success = Boolean.FALSE;
    private ResponseHeader header;
    private T body;

    private ResponseTemplate() {
    }

    public static <T> ResponseTemplate<T> success() {
        return super.setCode(SUCCESS.getCode()).setMessage(SUCCESS.getMessage());
    }

    public static <T> ResponseTemplate<T> success(T body) {
        return super.setCode(SUCCESS.getCode()).setMessage(SUCCESS.getMessage()).setBody(body);
    }

    public static <T> ResponseTemplate<T> fail() {
        return super.setCode(ERROR.getCode()).setMessage(ERROR.getMessage());
    }

    public static <T> ResponseTemplate<T> fail(String message) {
        message = StringUtils.isEmpty((String)message) ? ERROR.getMessage() : message;
        return super.setCode(ERROR.getCode()).setMessage(message);
    }

    public static <T> ResponseTemplate<T> fail(IReturnCode returnCode) {
        return super.setCode(returnCode.getCode()).setMessage(returnCode.getMessage());
    }

    public static <T> ResponseTemplate<T> fail(IReturnCode returnCode, String message) {
        message = StringUtils.isEmpty((String)message) ? returnCode.getMessage() : message;
        return super.setCode(returnCode.getCode()).setMessage(message);
    }

    public static <T> ResponseTemplate<T> fail(int code, String message) {
        return super.setCode(code).setMessage(message);
    }

    public int getCode() {
        return this.code;
    }

    private ResponseTemplate<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ResponseTemplate<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public ResponseTemplate<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResponseHeader getHeader() {
        return this.header;
    }

    public ResponseTemplate<T> setHeader(ResponseHeader header) {
        this.header = header;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public ResponseTemplate<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public String toString() {
        return "ResultTemplate{code=" + this.code + ", message='" + this.message + '\'' + ", success=" + this.success + ", header=" + this.header + ", body=" + this.body + '}';
    }
}

