/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.api.result;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.api.result.ResultHeader;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResultTemplate<T>
implements Serializable {
    private static final long serialVersionUID = -4206473602305400988L;
    private static final IReturnCode DEFAULT_SUCCESS = IReturnCode.Default.SUCCESS;
    private static final IReturnCode DEFAULT_ERROR = IReturnCode.Default.ERROR;
    private String code;
    private String errCode;
    private String msg;
    private Boolean success = Boolean.FALSE;
    private ResultHeader header;
    private T body;

    public static <T> ResultTemplate<T> success() {
        return super.setCode(DEFAULT_SUCCESS.getErrCode()).setMsg(DEFAULT_SUCCESS.getMsg());
    }

    public static <T> ResultTemplate<T> success(T body) {
        return super.setCode(DEFAULT_SUCCESS.getErrCode()).setMsg(DEFAULT_SUCCESS.getMsg()).setBody(body);
    }

    public static <T> ResultTemplate<T> fail() {
        return super.setCode(DEFAULT_ERROR.getErrCode()).setErrCode(DEFAULT_ERROR.getErrCode()).setMsg(DEFAULT_ERROR.getMsg());
    }

    public static <T> ResultTemplate<T> fail(String msg) {
        return super.setCode(DEFAULT_ERROR.getErrCode()).setErrCode(DEFAULT_ERROR.getErrCode()).setMsg(msg);
    }

    public static <T> ResultTemplate<T> fail(IReturnCode returnCode) {
        return super.setCode(DEFAULT_ERROR.getErrCode()).setErrCode(returnCode.getErrCode()).setMsg(returnCode.getMsg());
    }

    public static <T> ResultTemplate<T> fail(IReturnCode returnCode, String msg) {
        return super.setCode(DEFAULT_ERROR.getErrCode()).setErrCode(returnCode.getErrCode()).setMsg(msg);
    }

    public static <T> ResultTemplate<T> fail(String errCode, String msg) {
        return super.setCode(DEFAULT_ERROR.getErrCode()).setErrCode(errCode).setMsg(msg);
    }

    public String getCode() {
        return this.code;
    }

    private ResultTemplate<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public ResultTemplate<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public ResultTemplate<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResultHeader getHeader() {
        return this.header;
    }

    public ResultTemplate<T> setHeader(ResultHeader header) {
        this.header = header;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public ResultTemplate<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public ResultTemplate<T> setErrCode(String errCode) {
        this.errCode = errCode;
        return this;
    }

    public String toString() {
        return "ResultTemplate{code='" + this.code + '\'' + ", errCode='" + this.errCode + '\'' + ", msg='" + this.msg + '\'' + ", success=" + this.success + ", header=" + this.header + ", body=" + this.body + '}';
    }
}

