/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.api.ValidationStatusCode;
import com.feiniaojin.gracefulresponse.data.Response;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ControllerAdvice
@Order(value=100)
public class ValidationExceptionAdvice {
    private final Logger logger = LoggerFactory.getLogger(ValidationExceptionAdvice.class);
    @Resource
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Resource
    private ResponseStatusFactory responseStatusFactory;
    @Resource
    private ResponseFactory responseFactory;
    @Resource
    private GracefulResponseProperties gracefulResponseProperties;
    private static ExpressionParser parser = new SpelExpressionParser();

    @ExceptionHandler(value={BindException.class, ValidationException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public Response exceptionHandler(Exception e) throws Exception {
        if (e instanceof MethodArgumentNotValidException || e instanceof BindException) {
            ResponseStatus responseStatus = this.handleBindException((BindException)e);
            return this.responseFactory.newInstance(responseStatus);
        }
        if (e instanceof ConstraintViolationException) {
            ResponseStatus responseStatus = this.handleConstraintViolationException(e);
            return this.responseFactory.newInstance(responseStatus);
        }
        return this.responseFactory.newFailInstance();
    }

    private ResponseStatus handleBindException(BindException e) throws Exception {
        BindingResult bindingResult = e.getBindingResult();
        List allErrors = bindingResult.getAllErrors();
        String msg = allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(";"));
        ValidationStatusCode validateStatusCode = this.findValidationStatusCodeInController();
        if (validateStatusCode != null) {
            String code = validateStatusCode.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        List fieldErrors = e.getFieldErrors();
        FieldError fieldError = (FieldError)fieldErrors.get(0);
        String fieldName = fieldError.getField();
        Field field = null;
        Class<?> clazz = null;
        Object target = bindingResult.getTarget();
        if (!fieldName.contains(".")) {
            clazz = target.getClass();
        } else {
            String fieldParentPath = this.fieldParentPath(fieldName);
            fieldName = this.fieldSimpleName(fieldName);
            Expression expression = parser.parseExpression(fieldParentPath);
            clazz = expression.getValue(target).getClass();
        }
        field = clazz.getDeclaredField(fieldName);
        ValidationStatusCode annotation = field.getAnnotation(ValidationStatusCode.class);
        if (annotation != null) {
            String code = annotation.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        annotation = clazz.getAnnotation(ValidationStatusCode.class);
        if (annotation != null) {
            String code = annotation.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        if (target.getClass() != clazz && (annotation = target.getClass().getAnnotation(ValidationStatusCode.class)) != null) {
            String code = annotation.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        String code = this.gracefulResponseProperties.getDefaultValidateErrorCode();
        if (StringUtils.hasLength((String)code)) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.gracefulResponseProperties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private String fieldSimpleName(String fieldName) {
        int lastIndex = fieldName.lastIndexOf(".");
        StringBuilder stringBuilder = new StringBuilder();
        int length = fieldName.length();
        for (int i = lastIndex + 1; i < length; ++i) {
            stringBuilder.append(fieldName.charAt(i));
        }
        return stringBuilder.toString();
    }

    private String fieldParentPath(String fieldName) {
        int lastIndex = fieldName.lastIndexOf(".");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lastIndex; ++i) {
            stringBuilder.append(fieldName.charAt(i));
        }
        return stringBuilder.toString();
    }

    private Method currentControllerMethod() throws Exception {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)requestAttributes;
        HandlerExecutionChain handlerChain = this.requestMappingHandlerMapping.getHandler(sra.getRequest());
        assert (handlerChain != null);
        HandlerMethod handler = (HandlerMethod)handlerChain.getHandler();
        return handler.getMethod();
    }

    private ResponseStatus handleConstraintViolationException(Exception e) throws Exception {
        ConstraintViolationException exception = (ConstraintViolationException)e;
        Set violationSet = exception.getConstraintViolations();
        String msg = violationSet.stream().map(s -> s.getConstraintDescriptor().getMessageTemplate()).collect(Collectors.joining(";"));
        ValidationStatusCode validationStatusCode = this.findValidationStatusCodeInController();
        if (validationStatusCode != null) {
            String code = validationStatusCode.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        String code = this.gracefulResponseProperties.getDefaultValidateErrorCode();
        if (StringUtils.hasLength((String)code)) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.gracefulResponseProperties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private ValidationStatusCode findValidationStatusCodeInController() throws Exception {
        Method method = this.currentControllerMethod();
        ValidationStatusCode validateStatusCode = method.getAnnotation(ValidationStatusCode.class);
        if (validateStatusCode == null) {
            validateStatusCode = method.getDeclaringClass().getAnnotation(ValidationStatusCode.class);
        }
        return validateStatusCode;
    }
}

