/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.ArrayWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.KeyValueContext;
import com.fasterxml.jackson.dataformat.avro.ser.NopWriteContext;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public final class ObjectWriteContext
extends KeyValueContext {
    protected final GenericRecord _record;
    protected Schema.Field _nextField;

    public ObjectWriteContext(AvroWriteContext parent, AvroGenerator generator, GenericRecord record) {
        super(parent, generator, record.getSchema());
        this._record = record;
    }

    @Override
    public Object rawValue() {
        return this._record;
    }

    @Override
    public final AvroWriteContext createChildArrayContext() {
        this._verifyValueWrite();
        Schema.Field field = this._findField();
        if (field == null) {
            return new NopWriteContext(1, this, this._generator);
        }
        ArrayWriteContext child = new ArrayWriteContext(this, this._generator, this._createArray(field.schema()));
        this._record.put(this._currentName, ((AvroWriteContext)child).rawValue());
        return child;
    }

    @Override
    public final AvroWriteContext createChildObjectContext() throws JsonMappingException {
        this._verifyValueWrite();
        Schema.Field field = this._findField();
        if (field == null) {
            return new NopWriteContext(2, this, this._generator);
        }
        AvroWriteContext child = this._createObjectContext(field.schema());
        this._record.put(this._currentName, child.rawValue());
        return child;
    }

    @Override
    public AvroWriteContext createChildObjectContext(Object object) throws JsonMappingException {
        this._verifyValueWrite();
        Schema.Field field = this._findField();
        if (field == null) {
            return new NopWriteContext(2, this, this._generator);
        }
        AvroWriteContext child = this._createObjectContext(field.schema(), object);
        this._record.put(this._currentName, child.rawValue());
        return child;
    }

    @Override
    public final boolean writeFieldName(String name) {
        this._currentName = name;
        this._expectValue = true;
        Schema.Field field = this._schema.getField(name);
        if (field == null) {
            this._reportUnknownField(name);
            this._nextField = null;
            return false;
        }
        this._nextField = field;
        return true;
    }

    @Override
    public void writeValue(Object value) throws JsonMappingException {
        this._verifyValueWrite();
        if (this._nextField != null) {
            Schema schema = this._nextField.schema();
            if (schema.getType() == Schema.Type.FIXED && value instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)value;
                byte[] bytes = bb.array();
                if (bb.arrayOffset() != 0 || bb.remaining() != bytes.length) {
                    bytes = Arrays.copyOfRange(bytes, bb.arrayOffset(), bb.remaining());
                }
                value = new GenericData.Fixed(schema, bytes);
            }
            this._record.put(this._nextField.pos(), value);
        }
    }

    @Override
    public void writeString(String value) {
        this._verifyValueWrite();
        if (this._nextField != null) {
            this._record.put(this._nextField.pos(), (Object)value);
        }
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite();
        if (this._nextField != null) {
            this._record.put(this._nextField.pos(), null);
        }
    }

    protected final void _verifyValueWrite() {
        if (!this._expectValue) {
            throw new IllegalStateException("Expecting FIELD_NAME, not value");
        }
        this._expectValue = false;
    }

    protected Schema.Field _findField() {
        if (this._currentName == null) {
            throw new IllegalStateException("No current field name");
        }
        Schema.Field f = this._schema.getField(this._currentName);
        if (f == null) {
            this._reportUnknownField(this._currentName);
        }
        return f;
    }

    protected void _reportUnknownField(String name) {
        if (!this._generator.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
            throw new IllegalStateException("No field named '" + this._currentName + "'");
        }
    }
}

