/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;

final class UnionReader
extends AvroStructureReader {
    private final AvroStructureReader[] _memberReaders;
    private final AvroParserImpl _parser;

    public UnionReader(AvroStructureReader[] memberReaders) {
        this(null, memberReaders, null);
    }

    private UnionReader(AvroReadContext parent, AvroStructureReader[] memberReaders, AvroParserImpl parser) {
        super(parent, 0, null);
        this._memberReaders = memberReaders;
        this._parser = parser;
    }

    @Override
    public UnionReader newReader(AvroReadContext parent, AvroParserImpl parser) {
        return new UnionReader(parent, this._memberReaders, parser);
    }

    @Override
    public JsonToken nextToken() throws IOException {
        int index = this._decodeIndex();
        AvroStructureReader reader = this._memberReaders[index].newReader(this._parent, this._parser);
        this._currToken = reader.nextToken();
        return this._currToken;
    }

    @Override
    public void skipValue(AvroParserImpl parser) throws IOException {
        int index = this._decodeIndex();
        this._memberReaders[index].skipValue(parser);
    }

    @Override
    public String nextFieldName() throws IOException {
        this.nextToken();
        return null;
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('?');
    }

    private final int _decodeIndex() throws IOException {
        int index = this._parser.decodeIndex();
        if (index < 0 || index >= this._memberReaders.length) {
            throw new JsonParseException((JsonParser)this._parser, String.format("Invalid index (%s); union only has %d types", index, this._memberReaders.length));
        }
        return index;
    }
}

