/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AvroTypeIdResolver
extends ClassNameIdResolver {
    private final Map<String, Class<?>> _idTypes = new HashMap();
    private final Map<Class<?>, String> _typeIds = new HashMap();

    public AvroTypeIdResolver(JavaType baseType, TypeFactory typeFactory, Collection<NamedType> subTypes) {
        this(baseType, typeFactory);
        if (subTypes != null) {
            for (NamedType namedType : subTypes) {
                this.registerSubtype(namedType.getType(), namedType.getName());
            }
        }
    }

    public AvroTypeIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    public void registerSubtype(Class<?> type, String name) {
        this._idTypes.put(name, type);
        this._typeIds.put(type, name);
    }

    protected JavaType _typeFromId(String id, DatabindContext ctxt) throws IOException {
        if (this._baseType.isPrimitive()) {
            return this._baseType;
        }
        Class<?> subType = this._idTypes.get(id);
        if (subType != null) {
            id = this._idFrom(null, subType, this._typeFactory);
        }
        try {
            return super._typeFromId(id, ctxt);
        }
        catch (InvalidTypeIdException | IllegalArgumentException e) {
            return null;
        }
    }
}

