/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

public abstract class ScalarDecoder {
    protected abstract JsonToken decodeValue(AvroParserImpl var1) throws IOException;

    protected abstract void skipValue(AvroParserImpl var1) throws IOException;

    public abstract AvroFieldReader asFieldReader(String var1, boolean var2);

    public abstract String getTypeId();

    protected static final class BytesDecimalReader
    extends ScalarDecoder {
        private final int _scale;

        public BytesDecimalReader(int scale) {
            this._scale = scale;
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeBytesDecimal(this._scale);
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipBytesDecimal();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(BigDecimal.class);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId(), this._scale);
        }

        private static final class FR
        extends AvroFieldReader {
            private final int _scale;

            public FR(String name, boolean skipper, String typeId, int scale) {
                super(name, skipper, typeId);
                this._scale = scale;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeBytesDecimal(this._scale);
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipFloat();
            }
        }
    }

    protected static final class FixedDecimalReader
    extends ScalarDecoder {
        private final int _scale;
        private final int _size;

        public FixedDecimalReader(int scale, int size) {
            this._scale = scale;
            this._size = size;
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeFixedDecimal(this._scale, this._size);
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipFixedDecimal(this._size);
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(BigDecimal.class);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId(), this._scale, this._size);
        }

        private static final class FR
        extends AvroFieldReader {
            private final int _scale;
            private final int _size;

            public FR(String name, boolean skipper, String typeId, int scale, int size) {
                super(name, skipper, typeId);
                this._scale = scale;
                this._size = size;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeFixedDecimal(this._scale, this._size);
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipFixedDecimal(this._size);
            }
        }
    }

    protected static final class FixedDecoder
    extends ScalarDecoder {
        private final int _size;
        private final String _typeId;

        public FixedDecoder(int fixedSize, String typeId) {
            this._size = fixedSize;
            this._typeId = typeId;
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeFixed(this._size);
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipFixed(this._size);
        }

        @Override
        public String getTypeId() {
            return this._typeId;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this._size, this._typeId);
        }

        private static final class FR
        extends AvroFieldReader {
            private final int _size;

            public FR(String name, boolean skipper, int size, String typeId) {
                super(name, skipper, typeId);
                this._size = size;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeFixed(this._size);
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipFixed(this._size);
            }
        }
    }

    protected static final class EnumDecoder
    extends ScalarDecoder {
        protected final String _name;
        protected final String[] _values;

        public EnumDecoder(String name, List<String> enumNames) {
            this._name = name;
            this._values = enumNames.toArray(new String[enumNames.size()]);
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.setString(this._checkIndex(parser.decodeEnum()));
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            this._checkIndex(parser.decodeEnum());
        }

        private final String _checkIndex(int index) throws IOException {
            if (index < 0 || index >= this._values.length) {
                throw new IOException(String.format("Invalid Enum index (%s); enum '%s' only has %d types", index, this._name, this._values.length));
            }
            return this._values[index];
        }

        @Override
        public String getTypeId() {
            return this._name;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this, this._name);
        }

        private static final class FR
        extends AvroFieldReader {
            protected final String[] _values;

            public FR(String name, boolean skipper, EnumDecoder base, String typeId) {
                super(name, skipper, typeId);
                this._values = base._values;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.setString(this._checkIndex(parser.decodeEnum()));
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                this._checkIndex(parser.decodeEnum());
            }

            private final String _checkIndex(int index) throws IOException {
                if (index < 0 || index >= this._values.length) {
                    throw new IOException(String.format("Invalid Enum index (%s); enum '%s' only has %d types", index, this._name, this._values.length));
                }
                return this._values[index];
            }
        }
    }

    protected static final class ScalarUnionDecoder
    extends ScalarDecoder {
        public final ScalarDecoder[] _readers;

        public ScalarUnionDecoder(ScalarDecoder[] readers) {
            this._readers = readers;
        }

        @Override
        protected JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return this._checkIndex(parser.decodeIndex()).decodeValue(parser);
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            this._checkIndex(parser.decodeIndex()).skipValue(parser);
        }

        private ScalarDecoder _checkIndex(int index) throws IOException {
            if (index < 0 || index >= this._readers.length) {
                throw new IOException(String.format("Invalid Union index (%s); union only has %d types", index, this._readers.length));
            }
            return this._readers[index];
        }

        @Override
        public String getTypeId() {
            return null;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this._readers);
        }

        private static final class FR
        extends AvroFieldReader {
            public final ScalarDecoder[] _readers;

            public FR(String name, boolean skipper, ScalarDecoder[] readers) {
                super(name, skipper, null);
                this._readers = readers;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return this._checkIndex(parser.decodeIndex()).decodeValue(parser);
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                this._checkIndex(parser.decodeIndex()).skipValue(parser);
            }

            private ScalarDecoder _checkIndex(int index) throws IOException {
                if (index < 0 || index >= this._readers.length) {
                    throw new IOException(String.format("Invalid Union index (%s); union only has %d types", index, this._readers.length));
                }
                return this._readers[index];
            }
        }
    }

    protected static final class BytesDecoder
    extends ScalarDecoder {
        protected BytesDecoder() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeBytes();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipBytes();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(byte[].class);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeBytes();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipBytes();
            }
        }
    }

    protected static final class StringReader
    extends ScalarDecoder {
        private final String _typeId;

        public StringReader(String typeId) {
            this._typeId = typeId;
        }

        public StringReader() {
            this(AvroSchemaHelper.getTypeId(String.class));
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeStringToken();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipString();
        }

        @Override
        public String getTypeId() {
            return this._typeId;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeStringToken();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipString();
            }
        }
    }

    protected static final class NullReader
    extends ScalarDecoder {
        protected NullReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) {
            return JsonToken.VALUE_NULL;
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
        }

        @Override
        public String getTypeId() {
            return null;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper, null);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return JsonToken.VALUE_NULL;
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
            }
        }
    }

    protected static final class LongReader
    extends ScalarDecoder {
        protected LongReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeLongToken();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipLong();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(Long.TYPE);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeLongToken();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipLong();
            }
        }
    }

    protected static final class IntReader
    extends ScalarDecoder {
        private final String _typeId;

        public IntReader(String typeId) {
            this._typeId = typeId;
        }

        public IntReader() {
            this(AvroSchemaHelper.getTypeId(Integer.TYPE));
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            JsonToken token = parser.decodeIntToken();
            if (Character.class.getName().equals(this.getTypeId())) {
                return parser.setString(Character.toString((char)parser.getIntValue()));
            }
            return token;
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipInt();
        }

        @Override
        public String getTypeId() {
            return this._typeId;
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeIntToken();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipInt();
            }
        }
    }

    protected static final class FloatReader
    extends ScalarDecoder {
        protected FloatReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeFloat();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipFloat();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(Float.TYPE);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeFloat();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipFloat();
            }
        }
    }

    protected static final class DoubleReader
    extends ScalarDecoder {
        protected DoubleReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeDouble();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipDouble();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(Double.TYPE);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeDouble();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipDouble();
            }
        }
    }

    protected static final class BooleanDecoder
    extends ScalarDecoder {
        protected BooleanDecoder() {
        }

        @Override
        protected JsonToken decodeValue(AvroParserImpl parser) throws IOException {
            return parser.decodeBoolean();
        }

        @Override
        protected void skipValue(AvroParserImpl parser) throws IOException {
            parser.skipBoolean();
        }

        @Override
        public String getTypeId() {
            return AvroSchemaHelper.getTypeId(Boolean.TYPE);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this.getTypeId());
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper, String typeId) {
                super(name, skipper, typeId);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
                return parser.decodeBoolean();
            }

            @Override
            public void skipValue(AvroParserImpl parser) throws IOException {
                parser.skipBoolean();
            }
        }
    }
}

