/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.common.predicate.Marker;
import com.facebook.presto.jdbc.internal.common.predicate.Range;
import com.facebook.presto.jdbc.internal.common.predicate.SortedRangeSet;
import com.facebook.presto.jdbc.internal.common.type.DoubleType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.statistics.ConnectorHistogram;
import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import com.facebook.presto.jdbc.internal.spi.statistics.HistogramCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class DisjointRangeDomainHistogram
implements ConnectorHistogram {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(DisjointRangeDomainHistogram.class).instanceSize();
    private static final long RANGE_SIZE = ClassLayout.parseClass(Range.class).instanceSize();
    private final ConnectorHistogram source;
    private final Supplier<SortedRangeSet> rangeSet;
    private final Set<Range> ranges;

    @JsonCreator
    public DisjointRangeDomainHistogram(ConnectorHistogram source2, Set<Range> ranges) {
        this.source = Objects.requireNonNull(source2, "source is null");
        this.ranges = Objects.requireNonNull(ranges, "ranges is null");
        this.rangeSet = Utils.memoizedSupplier(() -> {
            SortedRangeSet rangeSet = SortedRangeSet.copyOf((Type)DoubleType.DOUBLE, new ArrayList<Range>(ranges));
            return rangeSet.subRangeSet(DisjointRangeDomainHistogram.getSourceSpan(this.source));
        });
    }

    private static Range getSourceSpan(ConnectorHistogram source2) {
        return Range.range(DoubleType.DOUBLE, source2.inverseCumulativeProbability(0.0).orElse(() -> Double.NEGATIVE_INFINITY), true, source2.inverseCumulativeProbability(1.0).orElse(() -> Double.POSITIVE_INFINITY), true);
    }

    @JsonProperty
    public ConnectorHistogram getSource() {
        return this.source;
    }

    @JsonProperty
    public SortedRangeSet getRanges() {
        return this.rangeSet.get();
    }

    public DisjointRangeDomainHistogram(ConnectorHistogram source2) {
        this(source2, Collections.emptySet());
    }

    @Override
    public Estimate cumulativeProbability(double value, boolean inclusive) {
        if (Double.isNaN(value)) {
            return Estimate.unknown();
        }
        Optional<Range> optionalSpan = this.getSpan();
        if (!optionalSpan.isPresent()) {
            return Estimate.of(0.0);
        }
        Range span = optionalSpan.get();
        if (value <= span.getLowValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY)) {
            return Estimate.of(0.0);
        }
        Range input = Range.range(DoubleType.DOUBLE, span.getLowValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY), span.getLow().getBound() == Marker.Bound.EXACTLY, value, inclusive);
        Estimate fullSetOverlap = this.calculateRangeSetOverlap(this.rangeSet.get());
        SortedRangeSet spanned = this.rangeSet.get().subRangeSet(input);
        Estimate spannedOverlap = this.calculateRangeSetOverlap(spanned);
        return spannedOverlap.flatMap(spannedProbability -> fullSetOverlap.map(fullSetProbability -> {
            if (fullSetProbability == 0.0) {
                return 0.0;
            }
            return Math.min(spannedProbability / fullSetProbability, 1.0);
        }));
    }

    private Estimate calculateRangeSetOverlap(SortedRangeSet ranges) {
        double cumulativeTotal = 0.0;
        for (Range range : ranges.getOrderedRanges()) {
            Estimate rangeProbability = this.getRangeProbability(range);
            if (rangeProbability.isUnknown()) {
                return Estimate.unknown();
            }
            cumulativeTotal += rangeProbability.getValue();
        }
        return Estimate.of(cumulativeTotal);
    }

    private Estimate getRangeProbability(Range range) {
        return HistogramCalculator.calculateFilterFactor(range, Double.NaN, this.source, Estimate.unknown(), false);
    }

    @Override
    public Estimate inverseCumulativeProbability(double percentile) {
        Utils.checkArgument(percentile >= 0.0 && percentile <= 1.0, "percentile must fall in [0.0, 1.0]", new Object[0]);
        Optional<Range> optionalSpan = this.getSpan();
        if (!optionalSpan.isPresent()) {
            return Estimate.unknown();
        }
        Range span = optionalSpan.get();
        double lower = span.getLowValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY);
        double upper = span.getHighValue().map(Double.class::cast).orElse(Double.POSITIVE_INFINITY);
        if (percentile == 0.0 && Double.isFinite(lower)) {
            return this.source.inverseCumulativeProbability(0.0).map(sourceMin -> Math.max(lower, sourceMin));
        }
        if (percentile == 1.0 && Double.isFinite(upper)) {
            return this.source.inverseCumulativeProbability(1.0).map(sourceMax -> Math.min(upper, sourceMax));
        }
        Estimate totalCumulativeEstimate = this.calculateRangeSetOverlap(this.rangeSet.get());
        if (totalCumulativeEstimate.isUnknown()) {
            return Estimate.unknown();
        }
        double totalCumulativeProbabilitySourceDomain = totalCumulativeEstimate.getValue();
        if (totalCumulativeProbabilitySourceDomain == 0.0) {
            return Estimate.unknown();
        }
        double cumulativeProbabilityNewDomain = 0.0;
        double lastRangeEstimateSourceDomain = 0.0;
        Range currentRange = null;
        for (Range range : this.rangeSet.get().getOrderedRanges()) {
            Estimate rangeEstimate = this.getRangeProbability(range);
            if (rangeEstimate.isUnknown()) {
                return Estimate.unknown();
            }
            currentRange = range;
            lastRangeEstimateSourceDomain = rangeEstimate.getValue();
            if (!((cumulativeProbabilityNewDomain += lastRangeEstimateSourceDomain / totalCumulativeProbabilitySourceDomain) >= percentile)) continue;
            break;
        }
        if (currentRange == null) {
            return Estimate.unknown();
        }
        Double currentLow = currentRange.getLowValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY);
        Estimate rangeLeftSourceEstimate = this.source.cumulativeProbability(currentLow, !currentRange.isLowInclusive());
        if (rangeLeftSourceEstimate.isUnknown()) {
            return Estimate.unknown();
        }
        double rangeLeftSource = rangeLeftSourceEstimate.getValue();
        double lastRangeProportionalProbability = lastRangeEstimateSourceDomain / totalCumulativeProbabilitySourceDomain;
        double percentileLeftFromNewDomain = percentile - cumulativeProbabilityNewDomain + lastRangeProportionalProbability;
        double percentilePoint = lastRangeEstimateSourceDomain * percentileLeftFromNewDomain / lastRangeProportionalProbability;
        double finalPercentile = rangeLeftSource + percentilePoint;
        return this.source.inverseCumulativeProbability(Math.min(Math.max(finalPercentile, 0.0), 1.0));
    }

    public DisjointRangeDomainHistogram addDisjunction(Range other) {
        HashSet<Range> ranges = new HashSet<Range>(this.ranges);
        ranges.add(other);
        return new DisjointRangeDomainHistogram(this.source, ranges);
    }

    public DisjointRangeDomainHistogram addConjunction(Range other) {
        return new DisjointRangeDomainHistogram(this.source, new HashSet<Range>(this.rangeSet.get().subRangeSet(other).getOrderedRanges()));
    }

    public static ConnectorHistogram addDisjunction(ConnectorHistogram histogram, Range range) {
        if (histogram instanceof DisjointRangeDomainHistogram) {
            return ((DisjointRangeDomainHistogram)histogram).addDisjunction(range);
        }
        return new DisjointRangeDomainHistogram(histogram, Collections.singleton(range));
    }

    public static ConnectorHistogram addConjunction(ConnectorHistogram histogram, Range range) {
        if (histogram instanceof DisjointRangeDomainHistogram) {
            return ((DisjointRangeDomainHistogram)histogram).addConjunction(range);
        }
        return new DisjointRangeDomainHistogram(histogram, Collections.singleton(range));
    }

    private Optional<Range> getSpan() {
        try {
            return Optional.of(this.rangeSet.get()).filter(set -> !set.isNone()).map(SortedRangeSet::getSpan);
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public String toString() {
        return "DisjointRangeDomainHistogram{source=" + this.source + ", , rangeSet" + this.rangeSet.get() + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisjointRangeDomainHistogram)) {
            return false;
        }
        DisjointRangeDomainHistogram other = (DisjointRangeDomainHistogram)o;
        return Objects.equals(this.source, other.source) && Objects.equals(this.getRanges(), other.getRanges());
    }

    public int hashCode() {
        return Objects.hash(this.source, this.getRanges());
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + RANGE_SIZE * (long)this.ranges.size();
    }
}

