/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.session;

import com.facebook.presto.jdbc.internal.spi.resourceGroups.ResourceGroupId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SessionConfigurationContext {
    private final String user;
    private final Optional<String> schema;
    private final Optional<String> source;
    private final Set<String> clientTags;
    private final Optional<String> queryType;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final Optional<String> clientInfo;
    private final String prestoServerVersion;

    public SessionConfigurationContext(String user, Optional<String> schema, Optional<String> source2, Set<String> clientTags, Optional<String> queryType, Optional<ResourceGroupId> resourceGroupId, Optional<String> clientInfo, String prestoServerVersion) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.source = Objects.requireNonNull(source2, "source is null");
        this.clientTags = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(clientTags, "clientTags is null")));
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.prestoServerVersion = Objects.requireNonNull(prestoServerVersion, "prestoServerVersion is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public String getPrestoServerVersion() {
        return this.prestoServerVersion;
    }
}

