/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandle;
import com.facebook.presto.jdbc.internal.spi.plan.OrderingScheme;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.CallExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final Set<VariableReferenceExpression> prePartitionedInputs;
    private final Specification specification;
    private final int preSortedOrderPrefix;
    private final Map<VariableReferenceExpression, Function> windowFunctions;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public WindowNode(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source2, @JsonProperty(value="specification") Specification specification, @JsonProperty(value="windowFunctions") Map<VariableReferenceExpression, Function> windowFunctions, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable, @JsonProperty(value="prePartitionedInputs") Set<VariableReferenceExpression> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix) {
        this(sourceLocation, id, Optional.empty(), source2, specification, windowFunctions, hashVariable, prePartitionedInputs, preSortedOrderPrefix);
    }

    public WindowNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source2, Specification specification, Map<VariableReferenceExpression, Function> windowFunctions, Optional<VariableReferenceExpression> hashVariable, Set<VariableReferenceExpression> prePartitionedInputs, int preSortedOrderPrefix) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(source2, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(hashVariable, "hashVariable is null");
        Utils.checkArgument(specification.getPartitionBy().containsAll(prePartitionedInputs), "prePartitionedInputs must be contained in partitionBy", new Object[0]);
        Optional<OrderingScheme> orderingScheme = specification.getOrderingScheme();
        Utils.checkArgument(preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().getOrderByVariables().size(), "Cannot have sorted more symbols than those requested", new Object[0]);
        Utils.checkArgument(preSortedOrderPrefix == 0 || prePartitionedInputs.equals(new HashSet<VariableReferenceExpression>(specification.getPartitionBy())), "preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned", new Object[0]);
        this.source = source2;
        this.prePartitionedInputs = Collections.unmodifiableSet(new LinkedHashSet<VariableReferenceExpression>(prePartitionedInputs));
        this.specification = specification;
        this.windowFunctions = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, Function>(windowFunctions));
        this.hashVariable = hashVariable;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        ArrayList<VariableReferenceExpression> outputVariables = new ArrayList<VariableReferenceExpression>(this.source.getOutputVariables());
        outputVariables.addAll(this.windowFunctions.keySet());
        return Collections.unmodifiableList(outputVariables);
    }

    public Set<VariableReferenceExpression> getCreatedVariable() {
        return this.windowFunctions.keySet();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Specification getSpecification() {
        return this.specification;
    }

    public List<VariableReferenceExpression> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.specification.orderingScheme;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<Frame> getFrames() {
        List frames = this.windowFunctions.values().stream().map(Function::getFrame).collect(Collectors.toList());
        return Collections.unmodifiableList(frames);
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 1);
        return new WindowNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.specification, this.windowFunctions, this.hashVariable, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new WindowNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.specification, this.windowFunctions, this.hashVariable, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Immutable
    public static final class Function {
        private final CallExpression functionCall;
        private final Frame frame;
        private final boolean ignoreNulls;

        @JsonCreator
        public Function(@JsonProperty(value="functionCall") CallExpression functionCall, @JsonProperty(value="frame") Frame frame, @JsonProperty(value="ignoreNulls") boolean ignoreNulls) {
            this.functionCall = Objects.requireNonNull(functionCall, "functionCall is null");
            this.frame = Objects.requireNonNull(frame, "Frame is null");
            this.ignoreNulls = ignoreNulls;
        }

        @JsonProperty
        public CallExpression getFunctionCall() {
            return this.functionCall;
        }

        @JsonProperty
        public FunctionHandle getFunctionHandle() {
            return this.functionCall.getFunctionHandle();
        }

        @JsonProperty
        public Frame getFrame() {
            return this.frame;
        }

        public int hashCode() {
            return Objects.hash(this.functionCall, this.frame, this.ignoreNulls);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.functionCall, other.functionCall) && Objects.equals(this.frame, other.frame) && Objects.equals(this.ignoreNulls, other.ignoreNulls);
        }

        @JsonProperty
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }
    }

    @Immutable
    public static class Frame {
        private final WindowType type;
        private final BoundType startType;
        private final Optional<VariableReferenceExpression> startValue;
        private final Optional<VariableReferenceExpression> sortKeyCoercedForFrameStartComparison;
        private final BoundType endType;
        private final Optional<VariableReferenceExpression> endValue;
        private final Optional<VariableReferenceExpression> sortKeyCoercedForFrameEndComparison;
        private final Optional<String> originalStartValue;
        private final Optional<String> originalEndValue;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowType type, @JsonProperty(value="startType") BoundType startType, @JsonProperty(value="startValue") Optional<VariableReferenceExpression> startValue, @JsonProperty(value="sortKeyCoercedForFrameStartComparison") Optional<VariableReferenceExpression> sortKeyCoercedForFrameStartComparison, @JsonProperty(value="endType") BoundType endType, @JsonProperty(value="endValue") Optional<VariableReferenceExpression> endValue, @JsonProperty(value="sortKeyCoercedForFrameEndComparison") Optional<VariableReferenceExpression> sortKeyCoercedForFrameEndComparison, @JsonProperty(value="originalStartValue") Optional<String> originalStartValue, @JsonProperty(value="originalEndValue") Optional<String> originalEndValue) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.sortKeyCoercedForFrameStartComparison = Objects.requireNonNull(sortKeyCoercedForFrameStartComparison, "sortKeyCoercedForFrameStartComparison is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.sortKeyCoercedForFrameEndComparison = Objects.requireNonNull(sortKeyCoercedForFrameEndComparison, "sortKeyCoercedForFrameEndComparison is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.originalStartValue = Objects.requireNonNull(originalStartValue, "originalStartValue is null");
            this.originalEndValue = Objects.requireNonNull(originalEndValue, "originalEndValue is null");
            if (startValue.isPresent()) {
                Utils.checkArgument(originalStartValue.isPresent(), "originalStartValue must be present if startValue is present", new Object[0]);
                if (type == WindowType.RANGE) {
                    Utils.checkArgument(sortKeyCoercedForFrameStartComparison.isPresent(), "for frame of type RANGE, sortKeyCoercedForFrameStartComparison must be present if startValue is present", new Object[0]);
                }
            }
            if (endValue.isPresent()) {
                Utils.checkArgument(originalEndValue.isPresent(), "originalEndValue must be present if endValue is present", new Object[0]);
                if (type == WindowType.RANGE) {
                    Utils.checkArgument(sortKeyCoercedForFrameEndComparison.isPresent(), "for frame of type RANGE, sortKeyCoercedForFrameEndComparison must be present if endValue is present", new Object[0]);
                }
            }
        }

        @JsonProperty
        public WindowType getType() {
            return this.type;
        }

        @JsonProperty
        public BoundType getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getSortKeyCoercedForFrameStartComparison() {
            return this.sortKeyCoercedForFrameStartComparison;
        }

        @JsonProperty
        public BoundType getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getEndValue() {
            return this.endValue;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getSortKeyCoercedForFrameEndComparison() {
            return this.sortKeyCoercedForFrameEndComparison;
        }

        @JsonProperty
        public Optional<String> getOriginalStartValue() {
            return this.originalStartValue;
        }

        @JsonProperty
        public Optional<String> getOriginalEndValue() {
            return this.originalEndValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            return this.type == frame.type && this.startType == frame.startType && Objects.equals(this.startValue, frame.startValue) && Objects.equals(this.sortKeyCoercedForFrameStartComparison, frame.sortKeyCoercedForFrameStartComparison) && this.endType == frame.endType && Objects.equals(this.endValue, frame.endValue) && Objects.equals(this.sortKeyCoercedForFrameEndComparison, frame.sortKeyCoercedForFrameEndComparison);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.startType, this.startValue, this.sortKeyCoercedForFrameStartComparison, this.endType, this.endValue, this.originalStartValue, this.originalEndValue, this.sortKeyCoercedForFrameEndComparison});
        }

        public static enum BoundType {
            UNBOUNDED_PRECEDING,
            PRECEDING,
            CURRENT_ROW,
            FOLLOWING,
            UNBOUNDED_FOLLOWING;

        }

        public static enum WindowType {
            RANGE,
            ROWS,
            GROUPS;

        }
    }

    @Immutable
    public static class Specification {
        private final List<VariableReferenceExpression> partitionBy;
        private final Optional<OrderingScheme> orderingScheme;

        @JsonCreator
        public Specification(@JsonProperty(value="partitionBy") List<VariableReferenceExpression> partitionBy, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.partitionBy = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(partitionBy));
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        }

        @JsonProperty
        public List<VariableReferenceExpression> getPartitionBy() {
            return this.partitionBy;
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.orderingScheme);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Specification other = (Specification)obj;
            return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderingScheme, other.orderingScheme);
        }
    }
}

