/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.CteMaterializationInfo;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.plan.StatisticAggregations;
import com.facebook.presto.jdbc.internal.spi.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.jdbc.internal.spi.plan.TableWriterNode;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TableFinishNode
extends PlanNode {
    private final PlanNode source;
    private final Optional<TableWriterNode.WriterTarget> target;
    private final VariableReferenceExpression rowCountVariable;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor;
    private final Optional<CteMaterializationInfo> temporaryTableInfo;

    @JsonCreator
    public TableFinishNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source2, @JsonProperty(value="target") Optional<TableWriterNode.WriterTarget> target, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor, @JsonProperty(value="cteMaterializationInfo") Optional<CteMaterializationInfo> temporaryTableInfo) {
        this(sourceLocation, id, Optional.empty(), source2, target, rowCountVariable, statisticsAggregation, statisticsAggregationDescriptor, temporaryTableInfo);
    }

    public TableFinishNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source2, Optional<TableWriterNode.WriterTarget> target, VariableReferenceExpression rowCountVariable, Optional<StatisticAggregations> statisticsAggregation, Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor, Optional<CteMaterializationInfo> temporaryTableInfo) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Utils.checkArgument(target != null || source2 instanceof TableWriterNode);
        this.temporaryTableInfo = temporaryTableInfo;
        this.source = Objects.requireNonNull(source2, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Utils.checkArgument(statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent(), "statisticsAggregation and statisticsAggregationDescriptor must both be either present or absent", new Object[0]);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<TableWriterNode.WriterTarget> getTarget() {
        return this.target;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return Collections.singletonList(this.rowCountVariable);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFinish(this, context);
    }

    public Optional<CteMaterializationInfo> getCteMaterializationInfo() {
        return this.temporaryTableInfo;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 1);
        return new TableFinishNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.target, this.rowCountVariable, this.statisticsAggregation, this.statisticsAggregationDescriptor, this.temporaryTableInfo);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new TableFinishNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.target, this.rowCountVariable, this.statisticsAggregation, this.statisticsAggregationDescriptor, this.temporaryTableInfo);
    }
}

