/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.constraints;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.constraints.TableConstraint;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UniqueConstraint<T>
extends TableConstraint<T> {
    public UniqueConstraint(LinkedHashSet<T> columnNames, boolean enabled, boolean rely, boolean enforced) {
        this(Optional.empty(), columnNames, enabled, rely, enforced);
    }

    @JsonCreator
    public UniqueConstraint(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="columns") LinkedHashSet<T> columnNames, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="rely") boolean rely, @JsonProperty(value="enforced") boolean enforced) {
        super(name, columnNames, enabled, rely, enforced);
    }

    @Override
    public <T, R> Optional<TableConstraint<R>> rebaseConstraint(Map<T, R> assignments) {
        if (this.getColumns().stream().allMatch(assignments::containsKey)) {
            return Optional.of(new UniqueConstraint<T>(this.getName(), this.getColumns().stream().map(assignments::get).collect(Collectors.toCollection(LinkedHashSet::new)), this.isEnabled(), this.isRely(), this.isEnforced()));
        }
        return Optional.empty();
    }
}

